/**
 * 鲸鱼游戏微信小游戏接入库
 * @author 推广技术部
 * @time: 2023-11-14
 *
 *  调试分享异常问题
 *
 */
class WechatSDK {
	private sdkVersion: string = "3.3.3";

	public LaunchOptions: Object; // 启动参数对象
	public SystemInfo: Object; // 设备信息
	public LoginData: Object; // 登录信息

	private onlineTime: number = 0; // 在线时长(单位:分钟)
	private actId: string = ""; // 动态消息活动id
	private clickCounter = 0; // 当前用户点击次数
	private GameRecorder: any = null; // 录屏对象
	private recorderBtn: any = null; // 对局回放分享按钮对象
	private contrlShareMenu: number = 0;  // 右上角分享开关
	constructor() {
		console.log("当前加载SDK版本号为:", this.sdkVersion);
		this.sdkInit();
		this.timerInit();
	}
	private timerInit() {
		// 用户在线时间
		let loginTime = new Date().getTime(); // 登录时间
		let offTime = (wx as any).getStorageSync("offlineTime"); // 离线前记录的时间点
		let offlineTime = offTime ? ((loginTime - offTime) / (1000 * 60)).toFixed(2) : 0; // 离线时长(分钟)
		if (offlineTime > 299) this.onlineTime = 0;
		else this.onlineTime = (wx as any).getStorageSync("onlineMinute") || 0;
		setInterval(() => {
			// 每分钟记录一次
			this.onlineTime++;
			let curTime = new Date().getTime();
			(wx as any).setStorageSync("onlineMinute", this.onlineTime);
			(wx as any).setStorageSync("offlineTime", curTime);
		}, 60000);
	}
	private sdkInit = async () => {
		this.LaunchOptions = await this.getOptionsInfo();
		this.actId = this.LaunchOptions["actId"] || "";
		this.SystemInfo = await this.getSystemInfo();
		this.SystemInfo["networkType"] = await this.getNetworkType();
		this.SDKCOMMDATA["os"] = this.SystemInfo["system"].split(" ")[0].toLowerCase();
	};
	public Login = async (retry = 0) => {
		if (retry > 2) {
			this.showMsg("登录异常，请联系客服.");
			return { error: "登录超时.." };
		}
		const res = await this.getWechatCode(); // 获取微信登录code
		if (res.code) {
			// 请求openid
			const { data } = await this.sdkRequest(Links.init, {
				...this.SDKCOMMDATA,
				appid: SDKConfig.appid,
				code: res.code,
			});
			this.LoginData = { ...data };
			this.SDKCOMMDATA["uuid"] = data.open_id;
			// SDK后台调试模式开关
			if (typeof data.debug_mode != "undefined" && data.debug_mode == 1) {
				(wx as any).setEnableDebug({
					enableDebug: true,
				});
			}
			this.actId != "" && this.updateShareMsgInfo({});
			return this.sdkActive();
		}
		retry += 1;
		this.Login(retry);
	};
	// SDK激活
	private sdkActive = async () => {
		const { data } = await this.sdkRequest(Links.active, { ...this.SDKCOMMDATA, ...this.LoginData });
		console.log("SDK active：", data);
		this.LoginData["pay_channel"] = data.default_pay_channel;
		this.LoginData["ad_unit_id"] = data.ad_unit_id;
		this.LoginData["game_club"] = data.game_club;
		this.contrlShareMenu = data.share;
		this.ActiReport(); // 上报激活
		return this.sdkLogin();
	};
	private async sdkLogin() {
		delete this.LoginData["token"]; // 强制清空登录toekn
		const { data, msg } = await this.sdkRequest(Links.login, { ...this.SDKCOMMDATA, ...this.LoginData });
		// console.log("--SDK登录返回::", data);
		if (Object.keys(data).length == 0) {
			this.showMsg(msg);
			return { error: msg };
		}
		this.LoginData = { ...this.LoginData, ...data };
		const filters = (({ create_time, ip, nickname, open_id, uid, enter_game, origin_uid, origin_open_id }) => ({
			create_time,
			ip,
			nickname,
			open_id,
			uid,
			enter_game,
			origin_uid,
			origin_open_id,
		}))(data);
		return {
			...filters,
			os: this.SDKCOMMDATA["os"], // 返回系统类型IOS或者android
			login_code: this.LoginData["encrypted"], // 返回加密后的session_key(后端加密:http://docs.pthzwl.net/#docs/backend/session_key)
			scene: this.LaunchOptions["scene"], // 用户来源场景值
			from_appid: this.LaunchOptions["appId"] || this.LaunchOptions["appid"],
			launchOptions: this.LaunchOptions,
			user_status: data.user_status || 0,
			game_club: this.LoginData["game_club"] || 0 // 游戏圈开关
		};
	}
	public payOrder = async (Params, showMessage = true) => {
		this.showLoading();
		// 支付前先获取用户订单状态，如果没有未完成订单则继续支付
		const { code, data, msg } = await this.fetchUri(
			Links.order,
			this.md5_sign({
				...this.SDKCOMMDATA,
				...Params,
				token: this.LoginData["token"],
				equipmentname: this.SystemInfo["model"] || '',
				equipmentos: this.SystemInfo["system"] || '',
				pay_channel: this.LoginData["pay_channel"]
			}),
			"GET"
		);
		this.hideLoading();
		// code不为0打印下单接口返回信息
		if (code) {
			this.showModal({
				title: "支付提示",
				content: msg,
				showCancel: false,
			});
			return { order_code: 0, msg: msg }; // 切支付状态
		}
		if (code == 0 && data.weixin_mini_program_app_id) {
			const params = {
				// 跳转参数
				appId: data.weixin_mini_program_app_id, // 跳转的小程序appid
				path: "", // 跳转到首页
				envVersion: SDKConfig.navPayEnv, //跳转方式
				extraData: {
					...this.SDKCOMMDATA,
					...Params,
					token: this.LoginData["token"],
					weixin_mini_program_app_id: data.weixin_mini_program_app_id, // 跳转小程序的appid，获取新openid用
					sub_product_code: data.sub_product_code, // 跳转小程序的productcode
					pay_channel: data.pay_channel, // 支付方式改变
					productKey: SDKConfig.productKey,
				},
			};
			console.log("--发起跳转支付", params);
			this.navigateToMiniProgram(params);
			return { order_code: 2, msg: "" }; // 切支付状态
		}
		if (code == 0 && data.open_customer_service) {
			const params = {
				title: "充值教程",
				content: "即将跳转官方【客服会话】进行充值, 向客服回复【充值】获取充值链接",
				showCancel: false,
				success: () => {
					this.Customer({
						sessionFrom: "order_id=" + (data.order_num || "") + "&payload=" + (data.payload || ""),
						showMessageCard: true,
						sendMessageTitle: "回复【充值】获取充值链接",
						sendMessageImg: "https://h5sdk.pthc8.com/resource/images/payTips.jpg",
					});
				},
			};
			this.showModal(params);
			return { order_code: 2, msg: "" };
		}
		if (code == 0 && data.order_type == 1) {
			this.MidasPaymentParams["buyQuantity"] = <number>(Params.money / 100) * <number>data.weixin_proportion; // 充值金额
			console.log("--米大师支付参数:", this.MidasPaymentParams);
			// 调微信米大师支付接口
			return new Promise((resolve, reject) => {
				(wx as any).requestMidasPayment({
					...this.MidasPaymentParams,
					success: async (response) => {
						console.log("--SDK支付成功:", response);
						let coinsResult = await this.getCoins({ ...this.SDKCOMMDATA, token: this.LoginData["token"], order_num: data.order_num });
						if (coinsResult.code == 0 || coinsResult.code == 3012) {
							resolve({ order_code: 200, msg: "" });
						} else {
							resolve({ order_code: 0, msg: coinsResult.msg || "" });
						}
					},
					fail: (err) => {
						console.log("--米大师支付失败:", err);
						let msg = this.MidasErrorCode[JSON.stringify(err.errCode)] || "支付异常";
						if (showMessage) {
							const params = {
								title: "支付提示",
								content: msg,
								showCancel: false,
							};
							this.showModal(params);
						}
						resolve({ order_code: err.errCode, msg: msg });
						this.reportPaymentError({ order_code: err.errCode, msg: msg, order_num: data.order_num });
					},
				});
			});
		}
	};
	private getCoins = async (orderParams) => {
		// 通知服务端扣费
		console.log("--通知扣费:", orderParams);
		return await this.sdkRequest(Links.pay, orderParams);
	};
	public createActiveShare = async (shareInfo) => {
		//动态消息
		let { code, data, msg } = await this.sdkRequest(
			Links.getActShareId,
			{
				...this.SDKCOMMDATA,
				room_limit: shareInfo.room_limit,
				target_state: 0,
			},
			"POST"
		);
		if (code == 0) {
			const actId = data.activity_id;
			const totalMembers = shareInfo.room_limit || "0";
			(wx as any).updateShareMenu({
				withShareTicket: true,
				isUpdatableMessage: true,
				activityId: this.actId, // 活动 ID
				templateInfo: {
					parameterList: [
						{
							name: "member_count",
							value: "1", // 设置房间初始玩家1
						},
						{
							name: "room_limit",
							value: totalMembers,
						},
					],
				},
				success: (res) => {
					let ShareParams = {
						title: shareInfo.title ? shareInfo.title : SDKConfig.shareTitle,
						imageUrl: shareInfo.image ? shareInfo.image : SDKConfig.shareImageUrl,
						imageId: shareInfo.imageId ? shareInfo.imageId : SDKConfig.shareImageId,
						query: "fromOpenId=" + this.LoginData["open_id"] + "&from=share&tag=0&actId=" + actId,
					};
					this.share(ShareParams);
				},
			});
		} else {
			console.log("--SDK错误::createActiveSahre", msg);
		}
	};

	public updateShareMsgInfo = (updateInfo) => {
		// 更新动态消息接口
		if (!updateInfo.activity_id || updateInfo.activity_id == "") {
			updateInfo = {
				...updateInfo,
				activity_id: this.actId,
				version_type: SDKConfig.navPayEnv,
			};
		}
		this.sdkRequest(Links.setActShareInfo, { ...this.SDKCOMMDATA, ...updateInfo }, "POST");
	};
	public getActiveShareInfo = async () => {
		// 查询动态消息接口
		let { code, data } = await this.sdkRequest(
			Links.getActShareInfo,
			{
				product_code: SDKConfig.productCode,
				activity_id: this.actId,
			},
			"POST"
		);
		return !code ? data : 0;
	};
	public async phoneCode(phoneInfo, callback?) {
		// 发送验证码接口
		const { code } = await this.sdkRequest(Links.sendCode, { ...this.SDKCOMMDATA, ...phoneInfo, type: "SDK.BIND_MOBILE" });
		callback && callback(!code);
	}
	public async userPhone(phoneInfo, callback) {
		// 绑定手机
		const { code } = await this.sdkRequest(Links.saveNum, { ...this.SDKCOMMDATA, open_id: this.LoginData["open_id"], ...phoneInfo, source: "WEIXIN" });
		callback(code);
	}
	public async checkUserPhoneBind() {
		// 查询用户绑定状态
		const { code } = await this.sdkRequest(Links.bindPhone, { ...this.SDKCOMMDATA, uid: this.LoginData["uid"] });
		return !code;
	}
	public async getUserPaymentType(roleInfo) {
		// 是否支持切支付
		let { code } = await this.sdkRequest(Links.payType, { ...this.SDKCOMMDATA, ...roleInfo });
		return !code;
	}
	// 创建录屏对象
	public createGameRecorder = (startEventCallBack?, stopEventCallBack?, cpCallback?) => {
		try {
			this.GameRecorder = (wx as any).getGameRecorder();
			if (!this.GameRecorder.isFrameSupported()) {
				if (cpCallback) cpCallback({ status: 0, msg: "设备不支持录屏功能." });
				return;
			}
			this.GameRecorder.on("start", () => {
				if (startEventCallBack) startEventCallBack();
			});
			this.GameRecorder.on("stop", (res) => {
				console.log("--对局回放时长:", res.duration);
				if (stopEventCallBack) stopEventCallBack(res);
			});
			if (cpCallback) cpCallback({ status: 1, msg: null });
		} catch (err) {
			console.log("--录屏异常:", err);
			if (cpCallback) cpCallback({ status: 0, msg: err });
		}
	};
	public startGameRecorder(recorderInfo: RecorderInfo) {
		try {
			this.GameRecorder.start({
				duration: recorderInfo.duration,
			});
		} catch (err) {
			console.log("$$SDK录屏异常::gameRecorder", err);
		}
	}
	public stopGameRecorder(shareInfo) {
		try {
			this.GameRecorder.stop();
			if (this.recorderBtn) this.recorderBtn.show();
			else this.createRecorderShareButton(shareInfo);
		} catch (err) {
			console.log("$$SDK录屏异常::gameRecorder", err);
		}
	}
	private createRecorderShareButton(shareInfo) {
		let recorderShareInfo = {
			style: {
				left: shareInfo.left,
				top: shareInfo.top,
				height: shareInfo.height,
				iconMarginRight: shareInfo.iconMarginRight,
				fontSize: shareInfo.fontSize,
				color: shareInfo.color,
				paddingLeft: shareInfo.paddingLeft,
				paddingRight: shareInfo.paddingRight,
			},
			icon: shareInfo.icon || "",
			image: shareInfo.image || "",
			text: shareInfo.text || "",
			share: {
				query: "fromOpenId=" + this.LoginData["open_id"] + "&from=share&tag=0&" + (shareInfo.query ? shareInfo.query : ""),
				bgm: shareInfo.bgm,
				timeRange: shareInfo.timeRange,
			},
		};
		this.recorderBtn = (wx as any).createGameRecorderShareButton(recorderShareInfo);
		// 当分享出现异常时才会触发点击回调
		this.recorderBtn.onTap((res) => {
			console.log("--录屏异常:", res);
		});
	}
	public hideGameRecorderShareButton() {
		if (this.recorderBtn) this.recorderBtn.hide();
	}
	public async checkUserAdvised() {
		// 防沉迷验证
		let time = this.onlineTime * 60; // 转成成秒
		return new Promise((resolve, reject) => {
			(wx as any).checkIsUserAdvisedToRest({
				todayPlayedTime: time,
				success: function (res) {
					resolve(res.result); // 是否建议用户休息
				},
				fail: function (res) {
					reject(res);
				},
			});
		});
	}
	// 获取用户信息
	public getUserInfo = (): Promise<any> => {
		return new Promise(async (resolve, reject) => {
			const status = await this._getSetting();
			const w = (wx as any).getSystemInfoSync().windowWidth;
			const h = (wx as any).getSystemInfoSync().windowHeight;
			if (status == 1) {
				const userInfo = await this._getUserInfo();
				if (userInfo.nickname) {
					// 上报用户授权
					this.ReportData({
						userInfo: { ...userInfo, nickName: encodeURI(userInfo.nickName) },
						action: "authorize",
					});
				}
				resolve(userInfo);
			} else if (status == 0) {
				// 用户已拒绝授权，再调用相关 API 或者 wx.authorize 会失败，需要引导用户到设置页面打开授权开关
				let OpenSettingButton = (wx as any).createOpenSettingButton({
					type: "text",
					text: "",
					style: {
						left: 0,
						top: 0,
						width: w,
						height: h,
					},
				});
				OpenSettingButton.onTap(async (res) => {
					let t_status = await this._getSetting();
					OpenSettingButton.offTap(this);
					OpenSettingButton.destroy();
					OpenSettingButton = null;
					if (t_status == 1) {
						let userInfo = await this._getUserInfo();
						// 上报用户授权
						this.ReportData({
							...userInfo,
							action: "authorize",
							nickName: encodeURI(userInfo.nickName),
						});
						resolve(userInfo);
					}
				});
			} else if (status == -1) {
				let userBtn = (wx as any).createUserInfoButton({
					type: "text",
					text: "",
					withCredentials: false,
					style: {
						left: 0,
						top: 0,
						width: w,
						height: h,
					},
				});
				userBtn.onTap((res) => {
					userBtn.offTap(this);
					userBtn.destroy();
					userBtn = null;
					if (res.userInfo) {
						let userInfo = res["userInfo"];
						// 上报用户授权
						this.ReportData({
							...userInfo,
							action: "authorize",
							nickName: encodeURI(userInfo.nickName),
						});
						resolve(userInfo);
					}
				});
			}
		});
	};
	private async _getUserInfo(): Promise<any> {
		return new Promise(async function (resolve, reject) {
			(wx as any).getUserInfo({
				withCredentials: false, //获取用户信息，withCredentials 为 true 时需要先调用 wx.login 接口。需要用户授权 scope.userInfo。
				success: (res) => {
					let userInfo = res["userInfo"];
					resolve(userInfo);
				},
				fail: (res: any) => {
					console.log("--SDK:玩家头像等数据失败，用户未授权");
					resolve({});
				},
			});
		});
	}
	private async _getSetting(): Promise<any> {
		return new Promise(async function (resolve, reject) {
			(wx as any).getSetting({
				success: function (res) {
					let authSetting = res.authSetting;
					if (authSetting["scope.userInfo"] === true) resolve(1);
					else if (authSetting["scope.userInfo"] === false) resolve(0);
					else resolve(-1);
				},
				fail: reject,
			});
		});
	}
	public addShareEvent = (shareInfo: shareInfo, callback?) => {
		if (!this.contrlShareMenu) return;
		(wx as any).onShareAppMessage(() => {
			if (callback) callback();
			const ShareParams = {
				title: shareInfo.title ? shareInfo.title : SDKConfig.shareTitle,
				imageUrl: shareInfo.image ? shareInfo.image : SDKConfig.shareImageUrl,
				imageUrlId: shareInfo.imageId ? shareInfo.imageId : SDKConfig.shareImageId,
				query: "fromOpenId=" + this.LoginData["open_id"] + "&from=share&tag=0&" + (shareInfo.query ? shareInfo.query : ""),
				withShareTicket: true,
			};
			return ShareParams;
		});
		(wx as any).showShareMenu({ withShareTicket: true });
	};
	// 暂时恢复，稍后删除
	public ShareApp(params?: string) {
		const ShareParams = {
			title: SDKConfig.shareTitle,
			imageUrl: SDKConfig.shareImageUrl,
			imageId: SDKConfig.shareImageId,
			query: "fromOpenId=" + this.LoginData["open_id"] + "&from=share&tag=0&" + (params ? params : ""),
		};
		return this.share(ShareParams);
	}
	public ShareGameInfo = (shareInfo?: shareInfo) => {
		// 参数，记录分享的用户openid
		const ShareParams = {
			title: shareInfo && shareInfo.title ? shareInfo.title : SDKConfig.shareTitle,
			imageUrl: shareInfo && shareInfo.image ? shareInfo.image : SDKConfig.shareImageUrl,
			imageId: shareInfo && shareInfo.imageId ? shareInfo.imageId : SDKConfig.shareImageId,
			query: "fromOpenId=" + this.LoginData["open_id"] + "&from=share&tag=0&" + (shareInfo.extraData ? shareInfo.extraData : ""),
		};
		return this.share(ShareParams);
	};
	private share = (DATA): Promise<any> => {
		return new Promise((resolve, reject) => {
			(wx as any).shareAppMessage({
				...DATA,
				withShareTicket: true,
				success: (res) => {
					resolve(1);
				},
				fail: (res) => {
					resolve(-1);
				},
			});
			setTimeout(function () {
				// 两秒后直接当分享成功返回
				resolve(2);
			}, 3000);
		});
	};
	// 切换游戏
	public navToOtherGame = (params) => {
		const obj = {
			// 跳转参数
			appId: params.appid, // 跳转的小程序appid
			path: "", // 跳转到首页
			envVersion: SDKConfig.navPayEnv, //跳转方式
			extraData: {
				from_openid: this.LoginData["open_id"],
				from_product: SDKConfig.productCode,
				from_uid: this.LoginData["uid"],
			},
		};
		this.navigateToMiniProgram(obj);
	};
	private navigateToMiniProgram = (params) => {
		if (this.SystemInfo["sdkVersion"] < "2.2") {
			this.showMsg("微信版本不兼容，请升级..");
		} else {
			(wx as any).navigateToMiniProgram(params);
		}
	};
	// 客服
	public Customer = (_orderInfo?) => {
		try {
			(wx as any).openCustomerServiceConversation(_orderInfo);
		} catch (err) {
			console.log("访问客服异常-->", err);
			this.showMsg("打开客服链接失败.");
		}
	};
	public ActiReport() {
		this.ReportData({ action: "activation" });
		this.heartBeatReport();
	} // 上报激活
	public RegisterReport() {
		this.ReportData({ action: "register" });
	} // 上报注册
	public LoginReport() {
		this.ReportData({ action: "login" });
	} // 上报登录
	public RoleLevelReport(roleInfo) {
		this.ReportData({ ...roleInfo, action: "roleUpgrade" });
	} // 上报等级
	public CustomReport(custInfo) {
		this.ReportData({ ...custInfo, action: "customevent" });
	} // 自定义上报
	public userClickEvent() {
		this.clickCounter++;
	}
	private heartBeatReport() {
		setTimeout(() => {
			this.clickReport();
			this.heartBeatReport();
		}, 60 * 1000);
	}
	private clickReport = async () => {
		this.ReportData({ action: "heartBeat" });
		this.clickCounter > 0 && this.ReportData({ action: "userappclick", click_times: this.clickCounter });
		this.clickCounter = 0; // 上报后归零
	};
	// 上报支付异常
	private reportPaymentError(err: Object) {
		let portData = {
			...this.SDKCOMMDATA,
			uid: this.LoginData["uid"],
			event_code: "PaymentError",
			event_data: JSON.stringify(err),
		};
		this.sdkRequest(Links.paymentErrorReport, portData, "POST");
	}
	// 数据上报接口，外部调用,参数中必须含有action值
	public ReportData(portData) {
		portData["launchOptions"] = this.LaunchOptions;
		portData["userInfo"] = { ...portData["userInfo"], ...{ userId: this.LoginData["uid"] || "", open_id: this.LoginData["open_id"] } };
		portData["systemInfo"] = this.SystemInfo;
		portData["product_code"] = SDKConfig.productCode;
		portData["time"] = Date.parse(new Date().toString()); // 获取当前时间戳秒
		console.log("--SDK上报:", portData);
		this.request(SDKConfig.report, portData, "POST");
	}
	// 退出小游戏
	public exitApp = () => {
		(wx as any).exitMiniProgram();
	};
	private getWechatCode = (): Promise<any> => {
		return new Promise((resolve, reject) => {
			try {
				(wx as any).login({
					success: (res) => {
						if (res.code) resolve(res);
						else {
							this.showMsg("执行wx.login返回成功，但无code参数", 5000);
							resolve({ code: 0 });
						}
					},
					fail: () => {
						this.showMsg("执行wx.login返回失败", 5000);
						resolve({ code: 0 });
					},
				});
			} catch (err) {
				this.showMsg("微信登录接口返回失败");
			}
		});
	};
	private showLoading() {
		(wx as any).showLoading({
			title: "请稍候..",
			mask: true,
		});
	}
	private hideLoading() {
		(wx as any).hideLoading();
	}
	private showModal(DATA) {
		(wx as any).showModal({
			...DATA,
			cancelText: "取消",
			confirmText: "确认",
		});
	}
	public showMsg = (str, duration = 3000) => {
		(wx as any).showToast({
			title: str,
			icon: "none",
			duration: duration,
		});
	};
	private getSystemInfo = (): Promise<any> => {
		return new Promise((resolve, reject) => {
			(wx as any).getSystemInfo({
				success: (res) => {
					resolve(res);
				},
			});
		});
	};
	public getNetworkType = (): Promise<any> => {
		return new Promise((resolve, reject) => {
			(wx as any).getNetworkType({
				success: (res) => {
					resolve(res.networkType);
				},
			});
		});
	};
	public getOptionsInfo = () => {
		const options = (wx as any).getLaunchOptionsSync();
		console.log("--启动参数--->", options);
		if (options.query && Object.keys(options.query).length > 0) {
			if (options.query.scene) {
				// 扫码参数
				const scene = this.toJson(decodeURIComponent(options.query.scene));
				return scene;
			} else return { ...options.query, scene: options.scene || "" }; // 普通url参数
		} else if (options.referrerInfo && options.referrerInfo.appId) {
			return { ...options.referrerInfo.extraData, scene: options.scene || "", appId: options.referrerInfo.appId }; // 小程序跳转附带参数
		} else return {};
	};
	// SDK上报接口
	private sdkRequest = async (link: string, portData, method?) => {
		portData = this.md5_sign(portData); // 附上签名参数
		console.log("--SDK接口:", portData);
		return await this.request(link, portData, method);
	};
	// 调用微信请求接口
	private request = async (URI: string, Params: any, Method = "GET") => {
		const { code, data, msg } = await this.fetchUri(URI, Params, Method);
		if (!data) return { code, data: {}, msg };
		if (!code) return { code, data, msg };
		if (code) this.showMsg(msg); // 输出接口异常
	};
	private fetchUri = (URI, DATA, METHOD): Promise<any> => {
		return new Promise((resolve, reject) => {
			try {
				(wx as any).request({
					url: URI,
					method: METHOD,
					data: DATA,
					header: {
						"Content-Type": "json",
					},
					success: (response) => {
						resolve(response.data);
					},
					fail: resolve,
				});
			} catch (err) {
				reject(err);
			}
		});
	};
	//把字符串转换成json
	private toJson = (str: string) => {
		let json = {};
		const jsonArr = str.split("&");
		for (let i = 0; i < jsonArr.length; i++) {
			const keyArr = jsonArr[i].split("=");
			json[keyArr[0]] = keyArr[1] || ""; // 附上key和对应的value
		}
		return json;
	};
	//接口签名，直接返回完整对象
	private md5_sign = (obj) => {
		obj.time = Date.parse(new Date().toString()); // 获取请求的时间戳秒
		let keys = Object.keys(obj).sort();
		let key_url = "";
		for (let i = 0; i < keys.length; i++) {
			if (keys[i] != "sign") key_url += keys[i] + "=" + obj[keys[i]] + "&";
		}
		key_url = key_url + SDKConfig.productKey;
		obj.sign = md5(key_url);
		return obj;
	};
	// SDK接口通用参数
	private SDKCOMMDATA: Object = {
		source: "WEIXIN",
		product_code: SDKConfig.productCode,
		uuid: "",
		equipmentos: "",
		package_code: "",
		time: "",
		sign: "",
		os: "",
		version: this.sdkVersion,
	};
	// 米大师支付参数
	private MidasPaymentParams = {
		mode: "game", // 支付的类型
		env: SDKConfig.midasPayEnv, // 米大师环境
		currencyType: "CNY", // 币种
		platform: "android", // 客户端平台
		zoneId: "1", // 分区ID,默认1
		offerId: SDKConfig.offerid,
	};
	private MidasErrorCode = {
		"-1": "系统失败",
		"-2": "支付取消",
		"-15001": "缺少参数",
		"-15002": "参数不合法",
		"-15003": "订单重复",
		"-15004": "后台错误",
		"-15005": "appId权限被封禁",
		"-15006": "货币类型不支持",
		"-15007": "订单已支付",
		"-15009": "由于健康系统限制，本次支付已超过限额",
		"1": "用户取消支付",
		"2": "客户端错误,判断到小程序在用户处于支付中时,又发起了一笔支付请求",
		"3": "Android 独有错误：用户使用 Google Play 支付，而手机未安装 Google Play",
		"4": "用户操作系统支付状态异常",
		"5": "操作系统错误",
		"6": "其他错误",
		"1000": "参数错误",
		"1003": "米大师Portal错误",
	};
	// 创建视频广告
	private videoAd: any = null; // 微信视频广告对象
	// 初始化激励视频
	public createWxVideoAd = async (adCallBack: AdCallBack) => {
		this.videoAd = await (wx as any).createRewardedVideoAd({
			adUnitId: SDKConfig.WXADUNITID,  // mp后台配置的广告id
		});
		this.videoAd.onError(err => {
			console.log('微信激励广告视频播放失败:', err);
			adCallBack.onError && adCallBack.onError(err);
		});
		// 监听广告关闭按钮
		this.videoAd.onClose(res => {
			// 用户点击【关闭广告】按钮
			adCallBack.onClose && adCallBack.onClose({ status: res && res.isEnded, type: 'video' });
			this.videoAd.offClose();
		});
	};
	// 激励视频播放
	public playAdVideo = async (Params: ProductInfo, callback: Function, retry: number = 0) => {
		if (retry > 2) {
			callback({ status: false });
			return;
		}
		this.videoAd.load()
			.then(() => {
				this.videoAd.show()
					.then(() => {
						console.log('微信激励广告视频播放成功.');
						this.CustomReport({ customeventName: "adVideoReport", customeventData: { ...Params } }); // 上报播放完成
						callback({ status: true });
					})
					.catch(err => this.playAdVideo(Params, callback, retry++));
			});

	}
}
declare interface shareInfo {
	title?: string;
	image?: string;
	imageId?: string;
	query?: string;
	success?: any;
	fail?: any;
	complete?: any;
	extraData?: any
}
declare interface RecorderInfo {
	duration: number;
}

declare interface ProductInfo {
	money: number
	product_id: string
	product_name: string
	product_num: number
	app_server: string
	role_level: number
	role_name: string
}

declare interface AdCallBack {
	onError?: Function
	onClose?: Function
}
// SDK后端接口（勿改）
const Links = {
	init: SDKConfig.sdk_domain + "/weixin/access_token.php", // 获取openid
	active: SDKConfig.sdk_domain + "/appInit.php", // SDK初始化接口
	login: SDKConfig.sdk_domain + "/login.php", // SDK登录接口，获取用户平台信息
	order: SDKConfig.pay_domain + "/pay.php", //订单接口
	pay: SDKConfig.pay_domain + "/notify/midas/pay.php", //扣费接口
	payType: SDKConfig.pay_domain + "/pay_channel/status.php", // 查询支付状态
	sendCode: SDKConfig.sdk_domain + "/sms/send.php", // 发送验证码
	saveNum: SDKConfig.sdk_domain + "/bind/mobile.php", // 保存手机号码
	playTime: SDKConfig.sdk_domain + "", // 获取用户在线时长
	bindPhone: SDKConfig.sdk_domain + "/bind/is_bind_mobile.php", // 用户手机绑定状态
	getActShareId: SDKConfig.active_domain + "/weixin/updatable_message/create_activity_id", // 获取活动消息id
	setActShareInfo: SDKConfig.active_domain + "/weixin/updatable_message/updatablemsg", // 更新活动消息内容
	getActShareInfo: SDKConfig.active_domain + "/weixin/updatable_message/get_activity", // 查询活动消息内容
	paymentErrorReport: SDKConfig.sdk_domain + "/v2/analytics/event", // 上报支付错误信息
};
// md5加密
const rotateLeft = (lValue, iShiftBits) => {
	return (lValue << iShiftBits) | (lValue >>> (32 - iShiftBits));
};
var addUnsigned = function (lX, lY) {
	var lX4, lY4, lX8, lY8, lResult;
	lX8 = lX & 2147483648;
	lY8 = lY & 2147483648;
	lX4 = lX & 1073741824;
	lY4 = lY & 1073741824;
	lResult = (lX & 1073741823) + (lY & 1073741823);
	if (lX4 & lY4) {
		return lResult ^ 2147483648 ^ lX8 ^ lY8;
	}
	if (lX4 | lY4) {
		if (lResult & 1073741824) {
			return lResult ^ 3221225472 ^ lX8 ^ lY8;
		} else {
			return lResult ^ 1073741824 ^ lX8 ^ lY8;
		}
	} else {
		return lResult ^ lX8 ^ lY8;
	}
};
var F = function (x, y, z) {
	return (x & y) | (~x & z);
};
var G = function (x, y, z) {
	return (x & z) | (y & ~z);
};
var H = function (x, y, z) {
	return x ^ y ^ z;
};
var I = function (x, y, z) {
	return y ^ (x | ~z);
};
var FF = function (a, b, c, d, x, s, ac) {
	a = addUnsigned(a, addUnsigned(addUnsigned(F(b, c, d), x), ac));
	return addUnsigned(rotateLeft(a, s), b);
};
var GG = function (a, b, c, d, x, s, ac) {
	a = addUnsigned(a, addUnsigned(addUnsigned(G(b, c, d), x), ac));
	return addUnsigned(rotateLeft(a, s), b);
};
var HH = function (a, b, c, d, x, s, ac) {
	a = addUnsigned(a, addUnsigned(addUnsigned(H(b, c, d), x), ac));
	return addUnsigned(rotateLeft(a, s), b);
};
var II = function (a, b, c, d, x, s, ac) {
	a = addUnsigned(a, addUnsigned(addUnsigned(I(b, c, d), x), ac));
	return addUnsigned(rotateLeft(a, s), b);
};
var convertToWordArray = function (string) {
	var lWordCount;
	var lMessageLength = string.length;
	var lNumberOfWordsTempOne = lMessageLength + 8;
	var lNumberOfWordsTempTwo = (lNumberOfWordsTempOne - (lNumberOfWordsTempOne % 64)) / 64;
	var lNumberOfWords = (lNumberOfWordsTempTwo + 1) * 16;
	var lWordArray = Array(lNumberOfWords - 1);
	var lBytePosition = 0;
	var lByteCount = 0;
	while (lByteCount < lMessageLength) {
		lWordCount = (lByteCount - (lByteCount % 4)) / 4;
		lBytePosition = (lByteCount % 4) * 8;
		lWordArray[lWordCount] = lWordArray[lWordCount] | (string.charCodeAt(lByteCount) << lBytePosition);
		lByteCount++;
	}
	lWordCount = (lByteCount - (lByteCount % 4)) / 4;
	lBytePosition = (lByteCount % 4) * 8;
	lWordArray[lWordCount] = lWordArray[lWordCount] | (128 << lBytePosition);
	lWordArray[lNumberOfWords - 2] = lMessageLength << 3;
	lWordArray[lNumberOfWords - 1] = lMessageLength >>> 29;
	return lWordArray;
};
var wordToHex = function (lValue) {
	var WordToHexValue = "",
		WordToHexValueTemp = "",
		lByte,
		lCount;
	for (lCount = 0; lCount <= 3; lCount++) {
		lByte = (lValue >>> (lCount * 8)) & 255;
		WordToHexValueTemp = "0" + lByte.toString(16);
		WordToHexValue = WordToHexValue + WordToHexValueTemp.substr(WordToHexValueTemp.length - 2, 2);
	}
	return WordToHexValue;
};
var uTF8Encode = function (string) {
	string = string.replace(/\x0d\x0a/g, "\x0a");
	var output = "";
	for (var n = 0; n < string.length; n++) {
		var c = string.charCodeAt(n);
		if (c < 128) {
			output += String.fromCharCode(c);
		} else {
			if (c > 127 && c < 2048) {
				output += String.fromCharCode((c >> 6) | 192);
				output += String.fromCharCode((c & 63) | 128);
			} else {
				output += String.fromCharCode((c >> 12) | 224);
				output += String.fromCharCode(((c >> 6) & 63) | 128);
				output += String.fromCharCode((c & 63) | 128);
			}
		}
	}
	return output;
};
function md5(string) {
	var x = Array();
	var k, AA, BB, CC, DD, a, b, c, d;
	var S11 = 7,
		S12 = 12,
		S13 = 17,
		S14 = 22;
	var S21 = 5,
		S22 = 9,
		S23 = 14,
		S24 = 20;
	var S31 = 4,
		S32 = 11,
		S33 = 16,
		S34 = 23;
	var S41 = 6,
		S42 = 10,
		S43 = 15,
		S44 = 21;
	string = uTF8Encode(string);
	x = convertToWordArray(string);
	a = 1732584193;
	b = 4023233417;
	c = 2562383102;
	d = 271733878;
	for (k = 0; k < x.length; k += 16) {
		AA = a;
		BB = b;
		CC = c;
		DD = d;
		a = FF(a, b, c, d, x[k + 0], S11, 3614090360);
		d = FF(d, a, b, c, x[k + 1], S12, 3905402710);
		c = FF(c, d, a, b, x[k + 2], S13, 606105819);
		b = FF(b, c, d, a, x[k + 3], S14, 3250441966);
		a = FF(a, b, c, d, x[k + 4], S11, 4118548399);
		d = FF(d, a, b, c, x[k + 5], S12, 1200080426);
		c = FF(c, d, a, b, x[k + 6], S13, 2821735955);
		b = FF(b, c, d, a, x[k + 7], S14, 4249261313);
		a = FF(a, b, c, d, x[k + 8], S11, 1770035416);
		d = FF(d, a, b, c, x[k + 9], S12, 2336552879);
		c = FF(c, d, a, b, x[k + 10], S13, 4294925233);
		b = FF(b, c, d, a, x[k + 11], S14, 2304563134);
		a = FF(a, b, c, d, x[k + 12], S11, 1804603682);
		d = FF(d, a, b, c, x[k + 13], S12, 4254626195);
		c = FF(c, d, a, b, x[k + 14], S13, 2792965006);
		b = FF(b, c, d, a, x[k + 15], S14, 1236535329);
		a = GG(a, b, c, d, x[k + 1], S21, 4129170786);
		d = GG(d, a, b, c, x[k + 6], S22, 3225465664);
		c = GG(c, d, a, b, x[k + 11], S23, 643717713);
		b = GG(b, c, d, a, x[k + 0], S24, 3921069994);
		a = GG(a, b, c, d, x[k + 5], S21, 3593408605);
		d = GG(d, a, b, c, x[k + 10], S22, 38016083);
		c = GG(c, d, a, b, x[k + 15], S23, 3634488961);
		b = GG(b, c, d, a, x[k + 4], S24, 3889429448);
		a = GG(a, b, c, d, x[k + 9], S21, 568446438);
		d = GG(d, a, b, c, x[k + 14], S22, 3275163606);
		c = GG(c, d, a, b, x[k + 3], S23, 4107603335);
		b = GG(b, c, d, a, x[k + 8], S24, 1163531501);
		a = GG(a, b, c, d, x[k + 13], S21, 2850285829);
		d = GG(d, a, b, c, x[k + 2], S22, 4243563512);
		c = GG(c, d, a, b, x[k + 7], S23, 1735328473);
		b = GG(b, c, d, a, x[k + 12], S24, 2368359562);
		a = HH(a, b, c, d, x[k + 5], S31, 4294588738);
		d = HH(d, a, b, c, x[k + 8], S32, 2272392833);
		c = HH(c, d, a, b, x[k + 11], S33, 1839030562);
		b = HH(b, c, d, a, x[k + 14], S34, 4259657740);
		a = HH(a, b, c, d, x[k + 1], S31, 2763975236);
		d = HH(d, a, b, c, x[k + 4], S32, 1272893353);
		c = HH(c, d, a, b, x[k + 7], S33, 4139469664);
		b = HH(b, c, d, a, x[k + 10], S34, 3200236656);
		a = HH(a, b, c, d, x[k + 13], S31, 681279174);
		d = HH(d, a, b, c, x[k + 0], S32, 3936430074);
		c = HH(c, d, a, b, x[k + 3], S33, 3572445317);
		b = HH(b, c, d, a, x[k + 6], S34, 76029189);
		a = HH(a, b, c, d, x[k + 9], S31, 3654602809);
		d = HH(d, a, b, c, x[k + 12], S32, 3873151461);
		c = HH(c, d, a, b, x[k + 15], S33, 530742520);
		b = HH(b, c, d, a, x[k + 2], S34, 3299628645);
		a = II(a, b, c, d, x[k + 0], S41, 4096336452);
		d = II(d, a, b, c, x[k + 7], S42, 1126891415);
		c = II(c, d, a, b, x[k + 14], S43, 2878612391);
		b = II(b, c, d, a, x[k + 5], S44, 4237533241);
		a = II(a, b, c, d, x[k + 12], S41, 1700485571);
		d = II(d, a, b, c, x[k + 3], S42, 2399980690);
		c = II(c, d, a, b, x[k + 10], S43, 4293915773);
		b = II(b, c, d, a, x[k + 1], S44, 2240044497);
		a = II(a, b, c, d, x[k + 8], S41, 1873313359);
		d = II(d, a, b, c, x[k + 15], S42, 4264355552);
		c = II(c, d, a, b, x[k + 6], S43, 2734768916);
		b = II(b, c, d, a, x[k + 13], S44, 1309151649);
		a = II(a, b, c, d, x[k + 4], S41, 4149444226);
		d = II(d, a, b, c, x[k + 11], S42, 3174756917);
		c = II(c, d, a, b, x[k + 2], S43, 718787259);
		b = II(b, c, d, a, x[k + 9], S44, 3951481745);
		a = addUnsigned(a, AA);
		b = addUnsigned(b, BB);
		c = addUnsigned(c, CC);
		d = addUnsigned(d, DD);
	}
	var tempValue = wordToHex(a) + wordToHex(b) + wordToHex(c) + wordToHex(d);
	return tempValue.toLowerCase();
}
