/**
 * 请在白鹭引擎的Main.ts中调用 platform.login() 方法调用至此处。
 */

class WxgamePlatform {

    name = 'wxgame'

    login() {
        return new Promise((resolve, reject) => {
            wx.login({
                success: (res) => {
                    resolve(res)
                },
                fail: (res) => {
                    reject(res)
                }
            })
        }).catch((error) => {
            console.error(error);
        })
    }

    getUserInfo() {
        return new Promise((resolve, reject) => {
            wx.getUserInfo({
                withCredentials: true,
                success: function(res) {
                    resolve(res);
                }
            })
        }).catch((error) => {
            console.error(error);
        })
    }

    onShow() {
        return new Promise((resolve, reject) => {
            wx.onShow(res => {
                const exParams = res.referrerInfo && res.referrerInfo.extraData && Object.keys(res.referrerInfo.extraData).length > 0 ? res.referrerInfo.extraData : {}
                // url参数
                resolve(Object.assign({}, res.query, exParams))
            })
        }).catch((error) => {
            console.error(error);
        })
    }

    getSystemInfo() {
        return new Promise((resolve, reject) => {
            wx.getSystemInfo({
                success: (res) => {
                    resolve(res);
                }
            })
        }).catch((error) => {
            console.error(error);
        })
    }

    getNetworkType() {
        return new Promise((resolve, reject) => {
            wx.getNetworkType({
                success: (res) => {
                    resolve(res);
                }
            })
        }).catch((error) => {
            console.error(error);
        })
    }

    request(URI, DATA, METHOD) {
        return new Promise((resolve, reject) => {
            wx.request({
                url: URI,
                method: METHOD,
                data: DATA,
                header: {
                    'Content-Type': 'json'
                },
                success: resolve,
                fail: reject
            })
        }).catch((error) => {
            reject(error)
        })
    }

    showModal(DATA) {
        wx.showModal(Object.assign({}, DATA, {
            cancelText: '取消',
            confirmText: '确认'
        }))
    }

    showMsg(str) {
        wx.showToast({
            title: str,
            duration: 1500
        })
    }

    share(DATA) {
        return new Promise((resolve, reject) => {
            wx.shareAppMessage(Object.assign(DATA, {
                success: function(res) {
                    resolve(res)
                },
                fail: function(res) {
                    reject(res)
                },
                complete() {}
            }))
        })
    }

    shareInit() {
        wx.showShareMenu({
            withShareTicket: true,
            success: () => {},
            fail: () => {},
            complete: () => {}
        })
    }

    addShareEvent(DATA) {
        wx.onShareAppMessage(() => {
            return Object.assign(DATA, {
                success: function() {},
                fail: function() {},
                complete() {}
            })
        })
    }

    getLaunchOptionsSync() {
        return new Promise((resolve, reject) => {
            const options = wx.getLaunchOptionsSync()
            if (Object.keys(options.query).length > 0 || Object.keys(options.referrerInfo).length > 0) {
                const obj = {}
                Object.assign(obj, options.query, options.referrerInfo.extraData)  // 合并数据
                resolve(obj)
            } else {
                reject(options)
            }
        })
    } 


    pay(params) {
        return new Promise((resolve, reject) => {
            wx.requestMidasPayment(Object.assign(params, {
                success: function(res) {
                    resolve(res)
                },
                fail: function(res) {
                    reject(res)
                },
                complete: function() {
                    console.log("Rechare")
                }
            }))
        })
    }

    customer(params) {
        wx.openCustomerServiceConversation(params)
    }

    navigateToMiniProgram(params) {
        wx.navigateToMiniProgram(params)
    }

    exitWechatApp() {
        return new Promise((resolve, reject) => {
            wx.exitMiniProgram({
                success: function(res) {
                    console.log('退出成功')
                    resolve(res)
                },
                fail: function(res) {
                    console.log('退出失败')
                    reject(res)
                }
            })
        })
    }

    openDataContext = new WxgameOpenDataContext();
}

class WxgameOpenDataContext {

    createDisplayObject(type, width, height) {
        const bitmapdata = new egret.BitmapData(sharedCanvas);
        bitmapdata.$deleteSource = false;
        const texture = new egret.Texture();
        texture._setBitmapData(bitmapdata);
        const bitmap = new egret.Bitmap(texture);
        bitmap.width = width;
        bitmap.height = height;

        if (egret.Capabilities.renderMode == "webgl") {
            const renderContext = egret.wxgame.WebGLRenderContext.getInstance();
            const context = renderContext.context;
            ////需要用到最新的微信版本
            ////调用其接口WebGLRenderingContext.wxBindCanvasTexture(number texture, Canvas canvas)
            ////如果没有该接口，会进行如下处理，保证画面渲染正确，但会占用内存。
            if (!context.wxBindCanvasTexture) {
                egret.startTick((timeStarmp) => {
                    egret.WebGLUtils.deleteWebGLTexture(bitmapdata.webGLTexture);
                    bitmapdata.webGLTexture = null;
                    return false;
                }, this);
            }
        }
        return bitmap;
    }


    postMessage(data) {
        const openDataContext = wx.getOpenDataContext();
        openDataContext.postMessage(data);
    }
}


window.platform = new WxgamePlatform();