/**
 * 鲸鱼游戏头条/抖音小游戏接入库
 * @author 推广技术部
 * @time: 2023-07-25
 */
class TTSDK {
    private sdkVersion: string = '2.0.2';
    private appInfo: AppInfo;
    private isBind = 0;  // 是否已经绑定过其他角色
    public LaunchOptions: any; // 启动参数对象
    public SystemInfo: any; // 设备信息
    public LoginData: any; // 登录信息

    private clickCounter: number = 0; // 当前用户点击次数
    private contrlShareMenu: number = 0;  // 右上角分享开关

    constructor() {
        console.log("当前加载SDK版本号为:", this.sdkVersion);
        this.sdkInit();
    }

    private sdkInit = async () => {
        this.LaunchOptions = await this.getOptionsInfo();
        this.SystemInfo = await this.getSystemInfo();
        this.SystemInfo["networkType"] = await this.getNetworkType();
        this.SDKCOMMDATA["os"] = this.SystemInfo["system"].split(" ")[0].toLowerCase();
    }

    public Login = async (retry = 0) => {
        if (retry > 2) {
            this.showMsg("登录异常，请联系客服.");
            return { error: "登录超时.." };
        }
        const ttUser = await this.ttLogin(false);
        let { code, data, msg } = await this.sdkRequest(ttLinks.init, {
            ...this.SDKCOMMDATA,
            appid: SDKConfig.appid,
            anonymous_code: ttUser.anonymousCode || '',
            code: ttUser.code || '',
        });
        if (!code) {
            this.LoginData = { ...data };
            this.SDKCOMMDATA["uuid"] = data.openid == "" ? data.anonymous_openid : data.openid;
            this.LoginData["open_id"] = data.openid;
            return this.SDKActive();
        } else
            console.error("SDK初始化异常:", msg);
        // 登录失败发起重连
        retry += 1;
        this.Login(retry);
    }
    private SDKActive = async (): Promise<any> => {
        const { data } = await this.sdkRequest(ttLinks.active, { ...this.SDKCOMMDATA, ...this.LoginData });
        this.LoginData["pay_channel"] = data.default_pay_channel;
        this.LoginData["ad_unit_id"] = data.ad_unit_id;
        this.LoginData["game_club"] = data.game_club;
        this.contrlShareMenu = data.share;
        this.ActiReport(); // 上报激活
        return this.SDKLogin();
    }
    /**
     * SDK登录接口
     * @returns SDK登录信息
     */
    private SDKLogin = async (): Promise<any> => {
        delete this.LoginData["token"]; // 强制清空登录toekn
        const { data, msg, code } = await this.sdkRequest(ttLinks.login, { ...this.SDKCOMMDATA, ...this.LoginData });
        if (Object.keys(data).length == 0) {
            this.showMsg(msg);
            return { code: code, message: msg };
        }
        // 游客帐号下已经绑定其他角色
        if (code == 182) {
            this.isBind = 1;
            return { code: code, message: msg }
        }
        this.LoginData = { ...this.LoginData, ...data, open_id: this.LoginData["openid"] };
        const filters = (({ create_time, ip = "", nickname, open_id, uid, enter_game = true, origin_uid = "", origin_open_id = "" }) => ({
            create_time,
            ip,
            nickname,
            open_id,
            uid,
            enter_game,
            origin_uid,
            origin_open_id
        }))(this.LoginData);
        return {
            ...filters,
            os: this.SDKCOMMDATA["os"], // 返回系统类型IOS或者android
            login_code: "",
            scene: this.LaunchOptions["scene"], // 用户来源场景值
            from_appid: this.LaunchOptions["appId"] || this.LaunchOptions["appid"],
            launchOptions: this.LaunchOptions,
            user_status: data.user_status || 0,
            game_club: 0 // 游戏圈开关
        };
    }
    /**
     * SDK支付接口
     * @returns { code: number, message: string }
     */
    public payOrder = async (Params: PaymentData): Promise<any> => {
        if (this.isBind == 1) {
            const msg = {
                title: '提示',
                content: '所绑定账号在本服已存在角色，请重新绑定新账号',
                showCancel: false
            }
            this.showModal(msg);
            return false;
        }
        // 支付前先判断用户是否登录
        const isLogin = await this.checkUserLogin();
        if (isLogin == -1) {
            const isGuest = await this.SDKQuickLogin();
            if (isGuest == -1) return { code: -1, message: '游客无法充值.' };
        }
        this.loadingView(true);
        const { code, data, msg } = await this.fetchUri(
            ttLinks.order,
            this.md5_sign({
                ...this.SDKCOMMDATA,
                ...Params,
                token: this.LoginData["token"],
                equipmentname: this.SystemInfo["model"] || '',
                equipmentos: this.SystemInfo["system"] || '',
                pay_channel: this.LoginData["pay_channel"]
            }),
            "GET"
        );
        this.loadingView(false);
        if (!code) {
            this.paymentData["buyQuantity"] = <number>(Params.money / 100) * <number>data.platform_payment_proportion; // 充值金额
            this.paymentData["customId"] = <string>data.order_num;
            this.paymentData["extraInfo"] = <string>data.extra;
            console.log("支付参数:", this.paymentData);
            // 调微信米大师支付接口
            return new Promise((resolve, reject) => {
                (tt as any).requestGamePayment({
                    ...this.paymentData,
                    success: async () => {
                        let { code, msg } = await this.getCoins({ ...this.SDKCOMMDATA, token: this.LoginData["token"], order_num: data.order_num });
                        if (code == 0 || code == 3012) {
                            resolve({ code: 0, message: "" });
                        } else {
                            resolve({ code: <number>code, message: msg });
                        }
                    },
                    fail: (err: any) => {
                        let msg = this.PaymentErrorCode[err.errCode];
                        const params = {
                            title: "支付提示",
                            content: msg || "支付异常",
                            showCancel: false,
                        };
                        this.showModal(params);
                        resolve({ code: err.errCode, message: msg });
                        this.reportPaymentError({ code: <number>err.errCode, message: msg, order_num: data.order_num });
                    },
                });
            });
        } else {
            const err = {
                title: '提示',
                content: msg,
                showCancel: false
            }
            this.showModal(err);
            return { code: <number>code, message: msg }
        }
    }
    // 通知服务端扣费
    private getCoins = async (orderParams: any) => {
        console.log("通知扣费:", orderParams);
        return await this.sdkRequest(ttLinks.pay, orderParams);
    };

    private SDKQuickLogin = async (): Promise<any> => {
        let ttLoginData = await this.ttLogin(true);
        if (ttLoginData.status == -1) {
            this.showMsg("用户取消登录.");
            return { code: -1, message: '用户取消登录' };
        }
        let { code, data, msg } = await this.sdkRequest(ttLinks.init, {
            ...this.SDKCOMMDATA,
            anonymous_code: ttLoginData.anonymousCode || '',
            appid: this.appInfo.appid,
            code: ttLoginData.code || ''
        });
        if (!code) {
            this.LoginData = { ...data };
            this.SDKCOMMDATA["uuid"] = data.openid;
            this.SDKCOMMDATA["uniqueid"] = data.anonymous_openid;
            this.SDKCOMMDATA["type"] = 'bind';

            let { code } = await this.SDKLogin();
            return code;
        }
    }

    private checkUserLogin = async (): Promise<any> => {
        return new Promise((resolve, reject) => {
            (tt as any).checkSession({
                success(res: any) {
                    resolve(0)
                },
                fail(res: any) {
                    resolve(-1);
                }
            });
        });
    }
    // 头条登录逻辑
    private ttLogin = (showLoginView: boolean): Promise<any> => {
        return new Promise<any>((resolve, reject) => {
            (tt as any).login({
                success: (res: any) => {
                    resolve({ ...res, status: 0 });
                },
                fail: (res: any) => {
                    resolve({ ...res, status: -1 }); // 用户取消登录
                },
                force: showLoginView // 是否唤醒登录框
            });
        });
    }

    public getOptionsInfo = async (): Promise<any> => {
        const options: any = (tt as any).getLaunchOptionsSync();
        console.log("游戏启动参数--->", options);
        if (options.query && Object.keys(options.query).length > 0) {
            if (options.query["scene"]) {
                // 扫码参数
                const scene = this.toJson(decodeURIComponent(options.query["scene"]));
                return scene;
            } else return { ...options.query, scene: options["scene"] || "" }; // 普通url参数
        } else if (options.referrerInfo && options.referrerInfo.appId) {
            return { ...options.referrerInfo.extraData, scene: options["scene"] || "", appId: options.referrerInfo.appId }; // 小程序跳转附带参数
        } else return {};
    }
    public getSystemInfo = (): Promise<any> => {
        return new Promise((resolve, reject) => {
            (tt as any).getSystemInfo({
                success: (res: any) => {
                    resolve(res);
                },
            });
        });
    };
    public getNetworkType = (): Promise<any> => {
        return new Promise((resolve, reject) => {
            (tt as any).getNetworkType({
                success: (res: any) => {
                    resolve(res.networkType);
                },
            });
        });
    };

    private sdkRequest = async (link: string, portData: any, method?: any): Promise<any> => {
        portData = this.md5_sign(portData); // 附上签名参数
        // console.log("SDK接口:", portData);
        return await this.request(link, portData, method);
    };
    // SDK接口签名方法
    private md5_sign(obj: any) {
        obj.time = Date.parse(new Date().toString())  // 获取请求的时间戳秒
        let keys = Object.keys(obj).sort();
        let key_url = "";
        for (let i = 0; i < keys.length; i++) {
            if (keys[i] != 'sign') key_url += keys[i] + '=' + obj[keys[i]] + '&'
        }
        key_url = key_url + SDKConfig.productKey
        obj.sign = md5(key_url)
        return obj
    }
    private request = async (URI: string, Params: any, Method = "GET") => {
        const { code, data, msg } = await this.fetchUri(URI, Params, Method);
        return { code, data: !data ? {} : data, msg };
    };
    private fetchUri = (URI: string, DATA: any, METHOD: string): Promise<any> => {
        return new Promise((resolve, reject) => {
            try {
                (tt as any).request({
                    url: URI,
                    method: METHOD,
                    data: DATA,
                    header: {
                        "Content-Type": "json",
                    },
                    success: (response: any) => {
                        resolve(response.data);
                    },
                    fail: resolve,
                });
            } catch (err) {
                reject(err);
            }
        });
    };
    //把字符串转换成json
    private toJson = (str: string) => {
        let json: any = {};
        const jsonArr = str.split("&");
        for (let i = 0; i < jsonArr.length; i++) {
            const keyArr = jsonArr[i].split("=");
            json[keyArr[0]] = keyArr[1] || "";
        }
        return json;
    };

    private showModal(DATA: any) {
        (tt as any).showModal({
            ...DATA,
            cancelText: "取消",
            confirmText: "确认",
        });
    }
    public showMsg = (str: string, duration = 3000) => {
        (tt as any).showToast({
            title: str,
            icon: "none",
            duration: duration,
        });
    };
    private loadingView(show: boolean) {
        if (show) {
            (tt as any).showLoading({
                title: '请稍候..',
                mask: true
            })
        } else {
            (tt as any).hideLoading();
        }

    }

    // 上报激活
    public ActiReport() {
        this.ReportData({ action: "activation" });
        this.heartBeatReport();
    }
    // 上报注册
    public RegisterReport() {
        this.ReportData({ action: 'register' });
    }
    // 上报登录
    public LoginReport() {
        this.ReportData({ action: 'login' })
    }
    // 上报等级
    public RoleLevelReport(roleInfo: any) {
        this.ReportData({ ...roleInfo, action: "roleUpgrade" });
    }
    // 自定义上报
    public CustomReport(custInfo: any) {
        this.ReportData({ ...custInfo, action: "customevent" });
    }
    public userClickEvent() {
        this.clickCounter++;
    }
    private heartBeatReport() {
        setTimeout(() => {
            this.clickReport();
            this.heartBeatReport();
        }, 60 * 1000);
    }
    private clickReport = async () => {
        this.ReportData({ action: "heartBeat" });
        this.clickCounter > 0 && this.ReportData({ action: "userappclick", click_times: this.clickCounter });
        this.clickCounter = 0; // 上报后归零
    };
    // 上报支付异常
    private reportPaymentError(err: Object) {
        let portData = {
            ...this.SDKCOMMDATA,
            uid: this.LoginData["uid"],
            event_code: "PaymentError",
            event_data: JSON.stringify(err),
        };
        this.sdkRequest(ttLinks.paymentErrorReport, portData, "POST");
    }
    // 数据上报接口，外部调用,参数中必须含有action值
    public ReportData(portData: any) {
        portData["launchOptions"] = this.LaunchOptions;
        portData["userInfo"] = { ...portData["userInfo"], ...{ userId: this.LoginData["uid"] || "", open_id: this.LoginData["openid"] || "", anonymous_openid: this.LoginData["anonymous_openid"] } };
        portData["systemInfo"] = this.SystemInfo;
        portData["product_code"] = SDKConfig.productCode;
        portData["time"] = Date.parse(new Date().toString()); // 获取当前时间戳秒
        console.log("--SDK上报:", portData);
        this.request(reportDomain, portData, "POST");
    }
    public phoneCode = async (phoneInfo: any, callback?: Function): Promise<any> => {
        // 发送验证码接口
        const { code } = await this.sdkRequest(ttLinks.sendCode, { ...this.SDKCOMMDATA, ...phoneInfo, type: "SDK.BIND_MOBILE" });
        callback && callback(code == 0);
    }
    public userPhone = async (phoneInfo: any, callback?: Function): Promise<any> => {
        // 绑定手机
        const { code } = await this.sdkRequest(ttLinks.saveNum, { ...this.SDKCOMMDATA, open_id: this.LoginData["openid"], ...phoneInfo, source: "WEIXIN" });
        callback && callback(code == 0);
    }
    public checkUserPhoneBind = async (): Promise<any> => {
        // 查询用户绑定状态
        const { code } = await this.sdkRequest(ttLinks.bindPhone, { ...this.SDKCOMMDATA, uid: this.LoginData["uid"] });
        return code == 0;
    }
    // 获取用户信息
    public getUserInfo = (): Promise<any> => {
        return new Promise(async (resolve, reject) => {
            const userInfo = await this._getUserInfo();
            if (userInfo.nickname) {
                // 上报用户授权
                this.ReportData({
                    userInfo: { ...userInfo, nickName: encodeURI(userInfo.nickName) },
                    action: "authorize",
                });
            }
            resolve(userInfo);
        });
    };
    private async _getUserInfo(): Promise<any> {
        return new Promise(async function (resolve, reject) {
            (tt as any).getUserInfo({
                withCredentials: false, //获取用户信息，withCredentials 为 true 时需要先调用 wx.login 接口。需要用户授权 scope.userInfo。
                success: (res: any) => {
                    let userInfo = res["userInfo"];
                    resolve(userInfo);
                },
                fail: (res: any) => {
                    console.log("--SDK:玩家头像等数据失败，用户未授权");
                    resolve({});
                },
            });
        });
    }
    public addShareEvent = (shareInfo: ShareInfo) => {
        if (!this.contrlShareMenu) return;
        (tt as any).onShareAppMessage(() => {
            const ShareParams = {
                title: shareInfo.title,
                imageUrl: shareInfo.image,
                imageUrlId: shareInfo.imageId,
                query: "fromOpenId=" + this.LoginData["openid"] + "&from=share&tag=0&" + (shareInfo.query ? shareInfo.query : ""),
                withShareTicket: true,
            };
            return ShareParams;
        });
        (tt as any).showShareMenu({ withShareTicket: true });
    };

    public ShareGame = (shareInfo: ShareInfo) => {
        // 参数，记录分享的用户openid
        const ShareParams = {
            title: shareInfo.title,
            imageUrl: shareInfo.image,
            imageUrlId: shareInfo.imageId,
            query: "fromOpenId=" + this.LoginData["openid"] + "&from=share&tag=0&" + (shareInfo.query ? shareInfo.query : ""),
        };
        return this._share(ShareParams);
    };
    private _share = (DATA: any): Promise<any> => {
        return new Promise((resolve, reject) => {
            (tt as any).shareAppMessage({
                ...DATA,
                withShareTicket: true,
                success: (res: any) => {
                    resolve(1);
                },
                fail: (res: any) => {
                    resolve(-1);
                },
            });
            setTimeout(function () {
                // 两秒后直接当分享成功返回
                resolve(2);
            }, 3000);
        });
    };
    // 客服
    public Customer = (_orderInfo?: any) => {
        try {
            (tt as any).openCustomerServiceConversation(_orderInfo);
        } catch (err) {
            console.log("访问客服异常:", err);
            this.showMsg("这傻鸟走开了.");
        }
    };
    // 添加桌面按钮（安卓）
    public addShortcut = (iconParam: ShortCut) => {
        (tt as any).addShortcut({
            ...iconParam
        });
    }

    // 头条必接录屏功能
    private GameRecorder: any = null;
    private videoPath: string = "";
    // 创建录屏对象
    public createGameRecorder = (startEventCallBack?: any, stopEventCallBack?: any) => {
        try {
            this.GameRecorder = (tt as any).getGameRecorderManager();
            this.GameRecorder.onStart((res: any) => {
                console.log("开始录屏:", res);
                if (startEventCallBack) startEventCallBack();
            });
            this.GameRecorder.onStop((res: any) => {
                console.log("结束录屏:", res);
                if (res) this.videoPath = res.videoPath;
                if (stopEventCallBack) stopEventCallBack();
            })
        } catch (err) {
            console.log("SDK录屏异常:", err);
        }
    }
    public startGameRecorder = (recorderInfo: ttRecorderInfo) => {
        this.GameRecorder.start({
            ...recorderInfo
        });
    }
    public stopGameRecorder() {
        this.GameRecorder.stop();
    }
    public shareVideo = async (shareInfo: ShareInfo) => {
        return new Promise((resolve, reject) => {
            (tt as any).shareAppMessage({
                channel: 'video',
                query: "fromOpenId=" + this.LoginData["openid"] + "&from=share&tag=0&" + (shareInfo.query ? shareInfo.query : ""),
                title: shareInfo.title,
                extra: {
                    videoPath: this.videoPath
                },
                success: function () {
                    console.log("分享视频成功.");
                    resolve({ code: 0, msg: '分享视频成功' });
                },
                fail: function () {
                    console.log("分享视频失败.");
                    resolve({ code: 1, msg: '分享视频失败' });
                }
            });
        });
    }

    // SDK接口通用参数
    private SDKCOMMDATA: any = {
        source: "TOUTIAO",
        product_code: SDKConfig.productCode,
        uuid: "",
        equipmentos: "",
        package_code: "",
        time: "",
        sign: "",
        os: "",
        version: this.sdkVersion,
    };

    // 米大师支付参数
    private paymentData = {
        mode: 'game',  // 支付的类型
        env: 0,  // 米大师支付环境  0:正式环境, 1:沙盒模式
        currencyType: 'CNY',   // 币种
        platform: 'android',
        buyQuantity: 10,
        customId: '',
        extraInfo: ''
    }
    private PaymentErrorCode: any = {
        "-1": "系统失败",
        "-2": "支付取消",
        "3023": "当前设备不支持",
        "-15001": "缺少参数",
        "-15002": "请求参数不合法",
        "-15003": "app 不支持小游戏支付",
        "-15006": "app 没有支付权限",
        "-15009": "内部错误，支付失败",
        "-15098": "当前用户未通过实名认证",
        "-15099": "当前用户累计支付金额超过限制",
        "-15101": "customId 为空或者不唯一",
        "-16000": "用户未登录",
        "2": "正在支付一起订单时，又发起了一笔支付请求",
        "3": "调起收银台失败",
        "4": "网络异常",
        "5": "IOS 平台错误，当前平台不支持支付",
        "6": "其他错误",
    }
}
// SDK后端接口（勿改）
const sdkDomain = 'https://account.shdxw.net';
const sdkPaymentDomain = 'https://pay.shdxw.net';
const reportDomain = 'https://s.shdxw.net/v2/sdkapi.php?jy_platform=toutiao_min_game';
const ttLinks = {
    init: sdkDomain + '/v2/toutiao/code2SessionKey',  // 获取openid
    active: sdkDomain + '/appInit.php',  // SDK初始化接口
    login: sdkDomain + '/v2/toutiao/login',  // SDK登录接口，获取用户平台信息
    order: sdkPaymentDomain + '/pay.php',  //订单接口
    pay: sdkPaymentDomain + '/notify/douyin/callback.php',  //扣费接口
    payType: sdkPaymentDomain + '/pay_channel/status.php',  // 查询支付状态
    sendCode: sdkDomain + '/sms/send.php',  // 发送验证码
    saveNum: sdkDomain + '/bind/mobile.php',  // 保存手机号码
    bindPhone: sdkDomain + '/bind/is_bind_mobile.php',  // 用户手机绑定状态
    paymentErrorReport: sdkDomain + "/v2/analytics/event", // 上报支付错误信息
}
class ShareInfo {
    title?: string
    image?: string
    query?: string
    imageId?: string
    success?: any
    fail?: any
    complete?: any
}
class RecorderInfo {
    time: number
    useMic: boolean
}
declare interface ProductInfo {
    money: number
    product_id: string
    product_name: string
    product_num: number
    app_server: string
    role_level: number
    role_name: string
}
declare interface AppInfo {
    appid: string
    productCode: string // SDK后台生成的产品code
    productKey: string // SDK后台生成的产品key
    appVersion?: string // 产品版本号
}
declare interface PaymentData {
    money: number
    product_id: string
    product_name: string
    product_num: number
    cp_order_num: string
    app_server: string
    role_level: number
    role_name: string
    passthrough_params?: string
}
declare interface ShortCut {
    success?: Function,
    fail?: Function
    complete?: Function
}
declare interface ttRecorderInfo {
    duration: number
    frameRate?: number
}
// md5加密
const ttrotateLeft = (lValue: any, iShiftBits: any) => { return (lValue << iShiftBits) | (lValue >>> (32 - iShiftBits)) }; var addUnsigned = function (lX: any, lY: any) { var lX4, lY4, lX8, lY8, lResult; lX8 = (lX & 2147483648); lY8 = (lY & 2147483648); lX4 = (lX & 1073741824); lY4 = (lY & 1073741824); lResult = (lX & 1073741823) + (lY & 1073741823); if (lX4 & lY4) { return (lResult ^ 2147483648 ^ lX8 ^ lY8) } if (lX4 | lY4) { if (lResult & 1073741824) { return (lResult ^ 3221225472 ^ lX8 ^ lY8) } else { return (lResult ^ 1073741824 ^ lX8 ^ lY8) } } else { return (lResult ^ lX8 ^ lY8) } }; var F = function (x: any, y: any, z: any) { return (x & y) | ((~x) & z) }; var G = function (x: any, y: any, z: any) { return (x & z) | (y & (~z)) }; var H = function (x: any, y: any, z: any) { return (x ^ y ^ z) }; var I = function (x: any, y: any, z: any) { return (y ^ (x | (~z))) }; var FF = function (a: any, b: any, c: any, d: any, x: any, s: any, ac: any) { a = addUnsigned(a, addUnsigned(addUnsigned(F(b, c, d), x), ac)); return addUnsigned(ttrotateLeft(a, s), b) }; var GG = function (a: any, b: any, c: any, d: any, x: any, s: any, ac: any) { a = addUnsigned(a, addUnsigned(addUnsigned(G(b, c, d), x), ac)); return addUnsigned(ttrotateLeft(a, s), b) }; var HH = function (a: any, b: any, c: any, d: any, x: any, s: any, ac: any) { a = addUnsigned(a, addUnsigned(addUnsigned(H(b, c, d), x), ac)); return addUnsigned(ttrotateLeft(a, s), b) }; var II = function (a: any, b: any, c: any, d: any, x: any, s: any, ac: any) { a = addUnsigned(a, addUnsigned(addUnsigned(I(b, c, d), x), ac)); return addUnsigned(ttrotateLeft(a, s), b) }; var convertToWordArray = function (string: any) { var lWordCount; var lMessageLength = string.length; var lNumberOfWordsTempOne = lMessageLength + 8; var lNumberOfWordsTempTwo = (lNumberOfWordsTempOne - (lNumberOfWordsTempOne % 64)) / 64; var lNumberOfWords = (lNumberOfWordsTempTwo + 1) * 16; var lWordArray = Array(lNumberOfWords - 1); var lBytePosition = 0; var lByteCount = 0; while (lByteCount < lMessageLength) { lWordCount = (lByteCount - (lByteCount % 4)) / 4; lBytePosition = (lByteCount % 4) * 8; lWordArray[lWordCount] = (lWordArray[lWordCount] | (string.charCodeAt(lByteCount) << lBytePosition)); lByteCount++ } lWordCount = (lByteCount - (lByteCount % 4)) / 4; lBytePosition = (lByteCount % 4) * 8; lWordArray[lWordCount] = lWordArray[lWordCount] | (128 << lBytePosition); lWordArray[lNumberOfWords - 2] = lMessageLength << 3; lWordArray[lNumberOfWords - 1] = lMessageLength >>> 29; return lWordArray }; var wordToHex = function (lValue: any) { var WordToHexValue = "", WordToHexValueTemp = "", lByte, lCount; for (lCount = 0; lCount <= 3; lCount++) { lByte = (lValue >>> (lCount * 8)) & 255; WordToHexValueTemp = "0" + lByte.toString(16); WordToHexValue = WordToHexValue + WordToHexValueTemp.substr(WordToHexValueTemp.length - 2, 2) } return WordToHexValue }; var uTF8Encode = function (string: any) { string = string.replace(/\x0d\x0a/g, "\x0a"); var output = ""; for (var n = 0; n < string.length; n++) { var c = string.charCodeAt(n); if (c < 128) { output += String.fromCharCode(c) } else { if ((c > 127) && (c < 2048)) { output += String.fromCharCode((c >> 6) | 192); output += String.fromCharCode((c & 63) | 128) } else { output += String.fromCharCode((c >> 12) | 224); output += String.fromCharCode(((c >> 6) & 63) | 128); output += String.fromCharCode((c & 63) | 128) } } } return output }; function md5(string: any) { var x = Array(); var k, AA, BB, CC, DD, a, b, c, d; var S11 = 7, S12 = 12, S13 = 17, S14 = 22; var S21 = 5, S22 = 9, S23 = 14, S24 = 20; var S31 = 4, S32 = 11, S33 = 16, S34 = 23; var S41 = 6, S42 = 10, S43 = 15, S44 = 21; string = uTF8Encode(string); x = convertToWordArray(string); a = 1732584193; b = 4023233417; c = 2562383102; d = 271733878; for (k = 0; k < x.length; k += 16) { AA = a; BB = b; CC = c; DD = d; a = FF(a, b, c, d, x[k + 0], S11, 3614090360); d = FF(d, a, b, c, x[k + 1], S12, 3905402710); c = FF(c, d, a, b, x[k + 2], S13, 606105819); b = FF(b, c, d, a, x[k + 3], S14, 3250441966); a = FF(a, b, c, d, x[k + 4], S11, 4118548399); d = FF(d, a, b, c, x[k + 5], S12, 1200080426); c = FF(c, d, a, b, x[k + 6], S13, 2821735955); b = FF(b, c, d, a, x[k + 7], S14, 4249261313); a = FF(a, b, c, d, x[k + 8], S11, 1770035416); d = FF(d, a, b, c, x[k + 9], S12, 2336552879); c = FF(c, d, a, b, x[k + 10], S13, 4294925233); b = FF(b, c, d, a, x[k + 11], S14, 2304563134); a = FF(a, b, c, d, x[k + 12], S11, 1804603682); d = FF(d, a, b, c, x[k + 13], S12, 4254626195); c = FF(c, d, a, b, x[k + 14], S13, 2792965006); b = FF(b, c, d, a, x[k + 15], S14, 1236535329); a = GG(a, b, c, d, x[k + 1], S21, 4129170786); d = GG(d, a, b, c, x[k + 6], S22, 3225465664); c = GG(c, d, a, b, x[k + 11], S23, 643717713); b = GG(b, c, d, a, x[k + 0], S24, 3921069994); a = GG(a, b, c, d, x[k + 5], S21, 3593408605); d = GG(d, a, b, c, x[k + 10], S22, 38016083); c = GG(c, d, a, b, x[k + 15], S23, 3634488961); b = GG(b, c, d, a, x[k + 4], S24, 3889429448); a = GG(a, b, c, d, x[k + 9], S21, 568446438); d = GG(d, a, b, c, x[k + 14], S22, 3275163606); c = GG(c, d, a, b, x[k + 3], S23, 4107603335); b = GG(b, c, d, a, x[k + 8], S24, 1163531501); a = GG(a, b, c, d, x[k + 13], S21, 2850285829); d = GG(d, a, b, c, x[k + 2], S22, 4243563512); c = GG(c, d, a, b, x[k + 7], S23, 1735328473); b = GG(b, c, d, a, x[k + 12], S24, 2368359562); a = HH(a, b, c, d, x[k + 5], S31, 4294588738); d = HH(d, a, b, c, x[k + 8], S32, 2272392833); c = HH(c, d, a, b, x[k + 11], S33, 1839030562); b = HH(b, c, d, a, x[k + 14], S34, 4259657740); a = HH(a, b, c, d, x[k + 1], S31, 2763975236); d = HH(d, a, b, c, x[k + 4], S32, 1272893353); c = HH(c, d, a, b, x[k + 7], S33, 4139469664); b = HH(b, c, d, a, x[k + 10], S34, 3200236656); a = HH(a, b, c, d, x[k + 13], S31, 681279174); d = HH(d, a, b, c, x[k + 0], S32, 3936430074); c = HH(c, d, a, b, x[k + 3], S33, 3572445317); b = HH(b, c, d, a, x[k + 6], S34, 76029189); a = HH(a, b, c, d, x[k + 9], S31, 3654602809); d = HH(d, a, b, c, x[k + 12], S32, 3873151461); c = HH(c, d, a, b, x[k + 15], S33, 530742520); b = HH(b, c, d, a, x[k + 2], S34, 3299628645); a = II(a, b, c, d, x[k + 0], S41, 4096336452); d = II(d, a, b, c, x[k + 7], S42, 1126891415); c = II(c, d, a, b, x[k + 14], S43, 2878612391); b = II(b, c, d, a, x[k + 5], S44, 4237533241); a = II(a, b, c, d, x[k + 12], S41, 1700485571); d = II(d, a, b, c, x[k + 3], S42, 2399980690); c = II(c, d, a, b, x[k + 10], S43, 4293915773); b = II(b, c, d, a, x[k + 1], S44, 2240044497); a = II(a, b, c, d, x[k + 8], S41, 1873313359); d = II(d, a, b, c, x[k + 15], S42, 4264355552); c = II(c, d, a, b, x[k + 6], S43, 2734768916); b = II(b, c, d, a, x[k + 13], S44, 1309151649); a = II(a, b, c, d, x[k + 4], S41, 4149444226); d = II(d, a, b, c, x[k + 11], S42, 3174756917); c = II(c, d, a, b, x[k + 2], S43, 718787259); b = II(b, c, d, a, x[k + 9], S44, 3951481745); a = addUnsigned(a, AA); b = addUnsigned(b, BB); c = addUnsigned(c, CC); d = addUnsigned(d, DD) } var tempValue = wordToHex(a) + wordToHex(b) + wordToHex(c) + wordToHex(d); return tempValue.toLowerCase() };
