/**
 * SDK版本:  v1.0
 * @author: 推广技术部
 * @copyright: 上海鲸团科技有限公司
 * @日期:    2018-10-10
 */
var SDKConfig = {

    appid: '1106966663',

    sdk_domain: 'https://account.jinsdk.com',  // SDK接口域名

    pay_domain: 'https://pay.jinsdk.com',  // 支付接口域名

    report_domain: 'https://s.jinsdk.com/qqxyx/api.php',  // 数据上报接口域名

    ProductCode: "47bf7b2b6f3bba55f5a8a3bafac102a2",

    product: '石器文明',  // 产品名称

}
var whaleSDK = {
    userInfo: {},
    sdkStatus: {
        initReady: false,  // 初始化完成
        loginReady: false,  // 登录完成
    },
    // 初始化SDK
    init: function (callback) {
        var _selt = this;
        // 配置公共参数
        _selt.ReportParams.extArgs = this.getQueryString("ext_args") ? decodeURI(this.getQueryString("ext_args")) : "";
        _selt.ReportParams.fromOpenId = _selt.getQueryString("fromOpenId") || "";
        _selt.ReportParams.clickId = _selt.getQueryString("qz_gdt") || "";

        _selt.sdkParams.product_code = _selt.ReportParams.productCode = SDKConfig.ProductCode;
        if (_selt.ReportParams.fromOpenId != '') _selt.ReportParams.extArgs = 'share';
        //发起登录
        this.login(function (isLogin) {
            if (isLogin) {
                _selt.sdkStatus.initReady = true;
                callback(true);
                return;
            }
            callback(false);
        });
        // 获取设备信息
        try {
            mqq.invoke("device", "getDeviceInfo",
                function (evt) {
                    console.log("@@SDK::getDeviceInfo", evt);
                    var device = evt.data;
                    var identifier = device.identifier ? device.identifier : "";  // 设备唯一标识
                    var model = device.modelVersion ? device.modelVersion : "";  // 机型
                    var osVerson = device.systemVersion ? device.systemVersion : "";  // 系统版本

                    _selt.sdkParams.uniqueid = _selt.ReportParams.identifier = _selt.userInfo.identifier = identifier;
                    _selt.ReportParams.modelVersion = _selt.userInfo.modelVersion = model;
                }
            );
        } catch (error) {
            console.log("@SDK::getDeviceInfo Error", error);
        }
    },
    // 设置屏幕常亮
    screenOpen: function () {
        try {
            mqq.device.setScreenStatus({
                status: 1
            }, function () { });
        } catch (error) {
            console.log("@@SDK::setScreenStatus Error", error)
        }
    },
    login: function (callback) {
        var _selt = this;
        //异步方式获取登录态
        window.getOpenKey(function (d) {
            _selt.userInfo.username = _selt.userInfo.account = _selt.ReportParams.openId = window.OPEN_DATA.openid;
            _selt.userInfo.pf = window.OPEN_DATA.pf;

            _selt.sdkParams.os = _selt.getOsType();
            _selt.sdkParams.pf = window.OPEN_DATA.pf || "";
            _selt.sdkParams.appid = SDKConfig.appid;
            _selt.sdkParams.open_id = window.OPEN_DATA.openid || "";
            _selt.sdkParams.openkey = window.OPEN_DATA.openkey || "";
            _selt.sdkParams.loginType = window.OPEN_DATA.loginType || "";
            _selt.sdkParams.via = window.OPEN_DATA.via || "";
            _selt.sdkParams.equipmentos = window.OPEN_DATA.os || "";
            _selt.sdkParams.equipmentname = window.OPEN_DATA.app || "";
            _selt.sdkParams.version = window.OPEN_DATA.version || "";
            _selt.sdkParams.subVersion = window.OPEN_DATA.subVersion || "";
            _selt.sdkParams.appType = window.OPEN_DATA.appType || "";
            _selt.sdkParams.source = ('QZONE-' + _selt.sdkParams.loginType).toUpperCase();
            // SDK激活
            _selt.sdkRequest(Links.active, _selt.sdkParams, function (data) {
                if (data && data.code == 0) {
                    _selt.sdkParams.pay_channel = data.data.default_pay_channel;
                    _selt.reportData("activation");  // 上报激活
                    callback(true);
                } else {
                    console.log("@@SDK接口错误::", data.msg);
                }
            });
        });
        //发起SDK登录
        this.addStatusListen('initReady', function () {
            _selt.doLogin();
        });
    },
    doLogin: function () {
        var _selt = this;
        _selt.sdkRequest(Links.login, _selt.sdkParams, function (data) {
            if (data && data.code == 0) {
                _selt.sdkParams.token = data.data.token;  // 记录用户toekn
                _selt.userInfo.uid = _selt.ReportParams.userId = data.data.uid;  // 记录用户ID
                _selt.sdkStatus.loginReady = true;
            } else {
                console.log("@@SDK接口错误::", data.msg);
            }
        });
    },
    getuser: function () {
        this.addStatusListen('loginReady', function () {
            _selt.userInfo.ostype = _selt.getOsType();
            return _selt.userInfo;
        });
    },
    addStatusListen: function (type, callback) {
        var _selt = this;
        var val = 0;
        if (_selt.sdkStatus[type]) {
            callback();
        } else {
            Object.defineProperty(_selt.sdkStatus, type, {
                enumerable: true,
                configurable: true,
                get: function getter() { return val; },
                set: function setter(newVal) {
                    //如果新设置的值跟之前的值是相等的，则不需要
                    if (newVal === val) { return; }
                    callback();
                }
            })
        }
    },
    addShortcut: function (info) {
        try {
            // 显示收藏桌面快捷方式的浮点图标或功能按钮
            window.mqq.invoke("ui", "setOnAddShortcutHandler", {
                "callback": mqq.callback(function () {
                    mqq.ui.addShortcut({
                        action: "web",
                        title: info.title ? "单机游戏" : info.title,
                        icon: info.icon ? window.OPEN_DATA.appicon : info.icon,
                        url: window.OPEN_DATA.jumpurl,
                        callback: function (ret) {
                            console.log(ret);
                        }
                    });
                }, false, true)
            });
        } catch (error) {
            console.log("@@SDK错误::addShortcut", error);
        }
    },
    share: function (info) {
        try {
            // 设置web页面分享的监听事件
            mqq.invoke("ui", "setOnShareHandler", function (type) {
                mqq.invoke("ui", "shareMessage", {
                    title: info.title ? "石器文明" : info.title,
                    desc: info.desc ? "经典玩法，登录即送VIP3" : info.desc,
                    share_type: type,
                    share_url: window.OPEN_DATA.shareurl,
                    image_url: info.icon ? window.OPEN_DATA.appicon : info.icon,
                    back: true
                }, function (result) {
                    if (result && result.retCode == 0) {
                        alert("分享成功");
                    } else {
                        alert("分享取消");
                    }
                });
            });
            //拉起分享菜单
            mqq.ui.showShareMenu();
        } catch (error) {
            console.log("@@SDK错误::share", error);
        }
    },
    //上报注册
    reportRegister: function (callback) {
        this.reportData("register");
        try {
            window.reportRegister();
        } catch (error) {
            console.log("@@QQ上报注册失败::", error);
        }
        if (callback) callback(true);
    },
    //上报登录
    reportLogin: function (callback) {
        this.reportData("login");
        try {
            window.reportLogin();
        } catch (error) {
            console.log("@@QQ上报登录失败::", error);
        }
        if (callback) callback(true);
    },
    //上报创角
    createRole: function (roleInfo, callback) {
        this.reportData("createRole", roleInfo);
        if (callback) callback(true);
    },
    reportData: function (type, data) {
        var _selt = this;
        if (!this.sdkStatus.initReady) {
            return console.log("@@初始化SDK失败");
        }
        try {
            var postData = _selt.ReportParams;
            postData.action = type;
            postData.openId = _selt.userInfo.uid;
            postData.time = Date.parse(new Date()).toString().substr(0, 10);
            if (type == 'createRole') {
                postData.roleId = data.role_id;
                postData.server_id = data.server_id;
                postData.role_name = data.role_name;
                postData.server_name = data.server_name;
            }
            console.log("@@SDK 数据上报：", postData);
            $.ajax({
                url: SDKConfig.report_domain,
                type: "POST",
                dataType: "json",
                data: postData,
                success: function () {
                    // console.log("@@SDK上报数据成功");
                },
                fail: function () {
                    console.log("@@SDK上报数据失败");
                }
            });
        } catch (err) {
            console.log("@@SDK 错误::reportData", err)
        }
    },
    sdkRequest: function (uri, data, callback) {
        var _selt = this;
        if (_selt.sdkParams.uniqueid == '') {  // 当uniqueid为空时使用openid
            _selt.sdkParams.uniqueid = _selt.ReportParams.openId;
        }
        var postData = this.md5_sign(data);  // 附上签名参数
        console.log("@@SDK接口::参数", postData);
        $.ajax({
            url: uri,
            type: "POST",
            dataType: "json",
            data: postData,
            success: function (data) {
                // console.log("@@SDK上报数据成功");
                callback(data);
            },
            fail: function () {
                console.log("@@SDK上报数据失败");
            }
        })
    },
    //支付
    pay: function (orderInfo, callback) {
        var _selt = this;
        if (!_selt.sdkStatus.initReady) {
            return console.log("初始化SDK失败");
        }
        var postData = Object.assign({}, _selt.sdkParams, orderInfo);
        //获取订单信息
        _selt.sdkRequest(Links.order, postData, function (data) {
            console.log("@@SDK支付::订单返回", data);
            if (data && data.code == '3021') {  // 余额不足
                _selt.sdkParams.order_num = data.data.order_num;
                //呼起充值流程
                window.popPayTips({
                    version: "v2",
                    defaultScore: orderInfo.amount * 10,
                    appid: window.OPEN_DATA.appid
                });
            } else if (data && data.code == '0') {
                // 完成支付并发货成功
                _selt.printf('充值成功');
            } else {
                console.log("@@SDK下单失败::", data.msg);
                _selt.printf('支付失败：' + data.msg);
            }
        });

        window.__paySuccess = function () {
            //支付成功执行
            orderInfo.err_code = '1';
            orderInfo.status = true;

            _selt.sdkRequest(Links.deliver, _selt.sdkParams, function (data) {
                if (data && data.code == 0) {
                    _selt.printf('充值成功');
                } else {
                    _selt.printf("充值失败：" + data.msg);
                }
                delete _selt.sdkParams.order_num;  // 删除订单字段
            });
        }

        window.__payError = function () {
            orderInfo.err_code = '0';
            _selt.delOrder();
        }

        window.__payClose = function () {
            orderInfo.err_code = '-1';
            _selt.delOrder();
        }
    },
    delOrder: function () {
        _selt.sdkRequest(Links.delOrder, _selt.sdkParams, function (data) {
            _selt.printf("充值失败");
            delete _selt.sdkParams.order_num;  // 删除订单字段
        });
    },

    isMobile: function () {
        return navigator.userAgent.match(/android|iphone|ipad|ipod|blackberry|meego|symbianos|windowsphone|ucbrowser/i);
    },
    isIos: function () {
        return navigator.userAgent.match(/iphone|ipod|ios|ipad/i);
    },
    isAndroid: function () {
        return navigator.userAgent.match(/android/i);
    },
    // 系统类型
    getOsType: function () {
        var ostype = "other";
        if (this.isMobile()) {
            if (this.isIos()) {
                ostype = "ios";
            } else if (this.isAndroid()) {
                ostype = "android";
            }
        }
        return ostype;
    },
    getQueryString: function (name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
        var r = window.location.search.substr(1).match(reg);
        if (r != null) {
            return unescape(r[2]);
        }
        return null;
    },
    //接口签名，直接返回完整对象
    md5_sign: function (obj) {
        obj.time = Date.parse(new Date().toString())  // 获取请求的时间戳秒
        var keys = Object.keys(obj).sort();
        var key_url = "";
        for (var i = 0; i < keys.length; i++) {
            if (keys[i] != 'sign') key_url += keys[i] + '=' + obj[keys[i]] + '&'
        }
        key_url = key_url + SDKConfig.productKey
        obj.sign = md5(key_url)
        return obj
    },
    isArray: function (arr) {
        var toStr = Object.prototype.toString;
        if (typeof Array.isArray === 'function') {
            return Array.isArray(arr);
        }
        return toStr.call(arr) === '[object Array]';
    },
    printf: function (_txt) {
        try {
            var tips = {};
            tips.text = _txt;
            mqq.ui.showTips(tips);
        } catch (error) {
            console.log("@@SDK提示框错误::", error);
        }
    },
    // 统计上报参数
    ReportParams: {
        action: null,  // 必填，事件类型
        openId: null,  // 必填，微信openid，通过code去SDK接口换取
        userId: '',  // 必传，用户ID
        fromOpenId: "",
        productCode: null,  // 必填，产品code
        clickId: null,  // 点击id
        extArgs: null,  // 必填 广告来源标识
        time: null  // 必填，请求的时间戳（秒）
    },
    // SDK上报参数
    sdkParams: {
        product_code: "",  // 产品code
        appid: "",  // 小游戏appid
        time: "",  // 当前时间戳秒
        uniqueid: '',  // 设备唯一号
        mac: '',  // 网卡mac地址
        idfa: '',  // 苹果设备IDFA
        open_id: "",  // 用户openid
        password: '',  // 登录密码（微信免密） 
        source: 'QZONE',  // 用户来源
        token: '',  // 登录成功返回
        os: 'H5',  // 系统类型
        equipmentos: "",  // 系统版本
        equipmentname: "",  // 手机型号
        version: "",  // SDK版本
        package_code: '',  // 渠道标识
        sign: "",  // 签名
        unionid: '',  // 用户Unionid，用于切支付
        pay_channel: '',   // 支付方式初始化接口返回
    }
}
var Links = {
    active: SDKConfig.sdk_domain + '/appInit.php',  // SDK初始化接口
    login: SDKConfig.sdk_domain + '/login.php',  // SDK登录接口，获取用户平台信息
    order: SDKConfig.pay_domain + '/pay.php',  //订单接口
    deliver: SDKConfig.pay_domain + '/order/order_complete.php',  //扣费接口
    delOrder: SDKConfig.pay_domain + '/order/order_cancel.php'  //取消订单
}
// md5加密
var rotateLeft = (lValue, iShiftBits) => { return (lValue << iShiftBits) | (lValue >>> (32 - iShiftBits)) }; var addUnsigned = function (lX, lY) { var lX4, lY4, lX8, lY8, lResult; lX8 = (lX & 2147483648); lY8 = (lY & 2147483648); lX4 = (lX & 1073741824); lY4 = (lY & 1073741824); lResult = (lX & 1073741823) + (lY & 1073741823); if (lX4 & lY4) { return (lResult ^ 2147483648 ^ lX8 ^ lY8) } if (lX4 | lY4) { if (lResult & 1073741824) { return (lResult ^ 3221225472 ^ lX8 ^ lY8) } else { return (lResult ^ 1073741824 ^ lX8 ^ lY8) } } else { return (lResult ^ lX8 ^ lY8) } }; var F = function (x, y, z) { return (x & y) | ((~x) & z) }; var G = function (x, y, z) { return (x & z) | (y & (~z)) }; var H = function (x, y, z) { return (x ^ y ^ z) }; var I = function (x, y, z) { return (y ^ (x | (~z))) }; var FF = function (a, b, c, d, x, s, ac) { a = addUnsigned(a, addUnsigned(addUnsigned(F(b, c, d), x), ac)); return addUnsigned(rotateLeft(a, s), b) }; var GG = function (a, b, c, d, x, s, ac) { a = addUnsigned(a, addUnsigned(addUnsigned(G(b, c, d), x), ac)); return addUnsigned(rotateLeft(a, s), b) }; var HH = function (a, b, c, d, x, s, ac) { a = addUnsigned(a, addUnsigned(addUnsigned(H(b, c, d), x), ac)); return addUnsigned(rotateLeft(a, s), b) }; var II = function (a, b, c, d, x, s, ac) { a = addUnsigned(a, addUnsigned(addUnsigned(I(b, c, d), x), ac)); return addUnsigned(rotateLeft(a, s), b) }; var convertToWordArray = function (string) { var lWordCount; var lMessageLength = string.length; var lNumberOfWordsTempOne = lMessageLength + 8; var lNumberOfWordsTempTwo = (lNumberOfWordsTempOne - (lNumberOfWordsTempOne % 64)) / 64; var lNumberOfWords = (lNumberOfWordsTempTwo + 1) * 16; var lWordArray = Array(lNumberOfWords - 1); var lBytePosition = 0; var lByteCount = 0; while (lByteCount < lMessageLength) { lWordCount = (lByteCount - (lByteCount % 4)) / 4; lBytePosition = (lByteCount % 4) * 8; lWordArray[lWordCount] = (lWordArray[lWordCount] | (string.charCodeAt(lByteCount) << lBytePosition)); lByteCount++ } lWordCount = (lByteCount - (lByteCount % 4)) / 4; lBytePosition = (lByteCount % 4) * 8; lWordArray[lWordCount] = lWordArray[lWordCount] | (128 << lBytePosition); lWordArray[lNumberOfWords - 2] = lMessageLength << 3; lWordArray[lNumberOfWords - 1] = lMessageLength >>> 29; return lWordArray }; var wordToHex = function (lValue) { var WordToHexValue = "", WordToHexValueTemp = "", lByte, lCount; for (lCount = 0; lCount <= 3; lCount++) { lByte = (lValue >>> (lCount * 8)) & 255; WordToHexValueTemp = "0" + lByte.toString(16); WordToHexValue = WordToHexValue + WordToHexValueTemp.substr(WordToHexValueTemp.length - 2, 2) } return WordToHexValue }; var uTF8Encode = function (string) { string = string.replace(/\x0d\x0a/g, "\x0a"); var output = ""; for (var n = 0; n < string.length; n++) { var c = string.charCodeAt(n); if (c < 128) { output += String.fromCharCode(c) } else { if ((c > 127) && (c < 2048)) { output += String.fromCharCode((c >> 6) | 192); output += String.fromCharCode((c & 63) | 128) } else { output += String.fromCharCode((c >> 12) | 224); output += String.fromCharCode(((c >> 6) & 63) | 128); output += String.fromCharCode((c & 63) | 128) } } } return output }; function md5(string) { var x = Array(); var k, AA, BB, CC, DD, a, b, c, d; var S11 = 7, S12 = 12, S13 = 17, S14 = 22; var S21 = 5, S22 = 9, S23 = 14, S24 = 20; var S31 = 4, S32 = 11, S33 = 16, S34 = 23; var S41 = 6, S42 = 10, S43 = 15, S44 = 21; string = uTF8Encode(string); x = convertToWordArray(string); a = 1732584193; b = 4023233417; c = 2562383102; d = 271733878; for (k = 0; k < x.length; k += 16) { AA = a; BB = b; CC = c; DD = d; a = FF(a, b, c, d, x[k + 0], S11, 3614090360); d = FF(d, a, b, c, x[k + 1], S12, 3905402710); c = FF(c, d, a, b, x[k + 2], S13, 606105819); b = FF(b, c, d, a, x[k + 3], S14, 3250441966); a = FF(a, b, c, d, x[k + 4], S11, 4118548399); d = FF(d, a, b, c, x[k + 5], S12, 1200080426); c = FF(c, d, a, b, x[k + 6], S13, 2821735955); b = FF(b, c, d, a, x[k + 7], S14, 4249261313); a = FF(a, b, c, d, x[k + 8], S11, 1770035416); d = FF(d, a, b, c, x[k + 9], S12, 2336552879); c = FF(c, d, a, b, x[k + 10], S13, 4294925233); b = FF(b, c, d, a, x[k + 11], S14, 2304563134); a = FF(a, b, c, d, x[k + 12], S11, 1804603682); d = FF(d, a, b, c, x[k + 13], S12, 4254626195); c = FF(c, d, a, b, x[k + 14], S13, 2792965006); b = FF(b, c, d, a, x[k + 15], S14, 1236535329); a = GG(a, b, c, d, x[k + 1], S21, 4129170786); d = GG(d, a, b, c, x[k + 6], S22, 3225465664); c = GG(c, d, a, b, x[k + 11], S23, 643717713); b = GG(b, c, d, a, x[k + 0], S24, 3921069994); a = GG(a, b, c, d, x[k + 5], S21, 3593408605); d = GG(d, a, b, c, x[k + 10], S22, 38016083); c = GG(c, d, a, b, x[k + 15], S23, 3634488961); b = GG(b, c, d, a, x[k + 4], S24, 3889429448); a = GG(a, b, c, d, x[k + 9], S21, 568446438); d = GG(d, a, b, c, x[k + 14], S22, 3275163606); c = GG(c, d, a, b, x[k + 3], S23, 4107603335); b = GG(b, c, d, a, x[k + 8], S24, 1163531501); a = GG(a, b, c, d, x[k + 13], S21, 2850285829); d = GG(d, a, b, c, x[k + 2], S22, 4243563512); c = GG(c, d, a, b, x[k + 7], S23, 1735328473); b = GG(b, c, d, a, x[k + 12], S24, 2368359562); a = HH(a, b, c, d, x[k + 5], S31, 4294588738); d = HH(d, a, b, c, x[k + 8], S32, 2272392833); c = HH(c, d, a, b, x[k + 11], S33, 1839030562); b = HH(b, c, d, a, x[k + 14], S34, 4259657740); a = HH(a, b, c, d, x[k + 1], S31, 2763975236); d = HH(d, a, b, c, x[k + 4], S32, 1272893353); c = HH(c, d, a, b, x[k + 7], S33, 4139469664); b = HH(b, c, d, a, x[k + 10], S34, 3200236656); a = HH(a, b, c, d, x[k + 13], S31, 681279174); d = HH(d, a, b, c, x[k + 0], S32, 3936430074); c = HH(c, d, a, b, x[k + 3], S33, 3572445317); b = HH(b, c, d, a, x[k + 6], S34, 76029189); a = HH(a, b, c, d, x[k + 9], S31, 3654602809); d = HH(d, a, b, c, x[k + 12], S32, 3873151461); c = HH(c, d, a, b, x[k + 15], S33, 530742520); b = HH(b, c, d, a, x[k + 2], S34, 3299628645); a = II(a, b, c, d, x[k + 0], S41, 4096336452); d = II(d, a, b, c, x[k + 7], S42, 1126891415); c = II(c, d, a, b, x[k + 14], S43, 2878612391); b = II(b, c, d, a, x[k + 5], S44, 4237533241); a = II(a, b, c, d, x[k + 12], S41, 1700485571); d = II(d, a, b, c, x[k + 3], S42, 2399980690); c = II(c, d, a, b, x[k + 10], S43, 4293915773); b = II(b, c, d, a, x[k + 1], S44, 2240044497); a = II(a, b, c, d, x[k + 8], S41, 1873313359); d = II(d, a, b, c, x[k + 15], S42, 4264355552); c = II(c, d, a, b, x[k + 6], S43, 2734768916); b = II(b, c, d, a, x[k + 13], S44, 1309151649); a = II(a, b, c, d, x[k + 4], S41, 4149444226); d = II(d, a, b, c, x[k + 11], S42, 3174756917); c = II(c, d, a, b, x[k + 2], S43, 718787259); b = II(b, c, d, a, x[k + 9], S44, 3951481745); a = addUnsigned(a, AA); b = addUnsigned(b, BB); c = addUnsigned(c, CC); d = addUnsigned(d, DD) } var tempValue = wordToHex(a) + wordToHex(b) + wordToHex(c) + wordToHex(d); return tempValue.toLowerCase() };