/** 
 * 平台数据接口。
 * 由于每款游戏通常需要发布到多个平台上，所以提取出一个统一的接口用于开发者获取平台数据信息
 * 推荐开发者通过这种方式封装平台逻辑，以保证整体结构的稳定
 * 由于不同平台的接口形式各有不同，白鹭推荐开发者将所有接口封装为基于 Promise 的异步形式
 */
declare interface Platform {

    getUserInfo(): Promise<any>;

    login(): Promise<any>

    getNetworkType(): Promise<any>

    getSystemInfo(): Promise<any>

    onShow(): Promise<any>

    request(uri, data, method): Promise<any>

    showModal(obj): Promise<any>

    share(obj): Promise<any>

    pay(params): Promise<any>

    shareInit(): Promise<any>

    addShareEvent(params): Promise<any>

    customer(params): Promise<any>

    navigateToMiniProgram(params): Promise<any>

    showToast(params): Promise<any>

    showMsg(str): Promise<any>

    exitWechatApp(): Promise<any>

    getLaunchOptionsSync(): Promise<any>

    createUserInfoButton(): Promise<any>

}

class DebugPlatform implements Platform {
    async getUserInfo() {}

    async login() {}

    async getNetworkType(){}

    async getSystemInfo(){}
    
    async onShow() {}

    async request(uri, data, method){}

    async showModal(obj) {}
    
    async share(obj) {}

    async pay(params) {}

    async shareInit() {}

    async addShareEvent(params) {}

    async customer(params) {}

    async navigateToMiniProgram(params) {}

    async showToast(params) {}

    async showMsg(str) {}

    async exitWechatApp() {}

    async getLaunchOptionsSync() {}

    async createUserInfoButton() {}

}


if (!window.platform) {
    window.platform = new DebugPlatform();
}



declare let platform: Platform;

declare interface Window {

    platform: Platform
}